/*****************************************************************************
 *                                                                           *
 *                               ICONLIST.CPP                                *
 *---------------------------------------------------------------------------*
 *  First version:  11/07/1994                                               *
 *  Latest release: 11/14/1994                                               *
 *---------------------------------------------------------------------------*
 *  By Emmanuel Thioux //1994                                                *
 *                                                                           *
 *****************************************************************************/

#include <Windows.h>
#include <dos.h>
#include <Shellapi.h>
#include <Windowsx.h>
#include <String.h>
#include "hook.h"
#include <StdLib.h>

#ifdef __WIN32__
  POINT  OldPos;
  #define MoveTo(a, b, c) MoveToEx(a, b, c, &OldPos)
#endif

ICONDATA TIcons[MAXICONS];

// Class name of the Icon list
char* szIconBar = "IconBar";

// numnber of icons in the list
int  NICONS = 0;

// Windows handles
HWND Iconhwnd;
HWND IconParent;
HWND Active;

// Tool Bar Length
int BarLength;

long FAR PASCAL _export IconWndProc(HWND hwnd,UINT message,UINT wParam,LONG lParam);
HWND CreateButton(HWND Parent, LPSTR Text, int x, int y);

#pragma warn -aus
BOOL MakeIconBar(HWND _Parent, int x, int y)
{
 WNDCLASS wndclass;
 char Profile[16] = "App#";
 char Number[5] = "0000";
 char *p;
 char J = 0;
 DWORD Unit;
 HDC  TempDC;

 BarLength = 0;
 IconParent = _Parent;
 wndclass.style         = CS_HREDRAW|CS_VREDRAW;   // WINDOW STYLE
 wndclass.lpfnWndProc   = IconWndProc;             // WND PROC
 wndclass.cbClsExtra    = 0;                       // EXTRAS
 wndclass.cbWndExtra    = 0;                       // EXTRAS
 wndclass.hInstance     = MainInstance;            // APP INSTANCE
 wndclass.hCursor       = LoadCursor(NULL,IDC_ARROW); // CURSOR
 wndclass.hbrBackground = (HBRUSH) GetStockObject(LTGRAY_BRUSH);
 wndclass.lpszMenuName  = NULL;                    // MENU
 wndclass.lpszClassName = (char*) szIconBar;       // CLASS NAME

 Active = GetActiveWin();
 GetProfileString("SpeedManu", "Applicationcount", "Error", Number, 32);
 NICONS = atoi(Number);
 // if no icon just exit
 if (NICONS == 0)
	 return FALSE;

 if (NICONS > MAXICONS)
	 {
	  PostMessage(IconParent, WM_USER + WM_ERROR, WININI_ERR, 0);
	  return FALSE;
	 }

 // Get the data for every buttons from the WIN.INI Section [SpeedManu]
 for (int I = 0; I < NICONS; J++)
	  {
		TIcons[I].ID = IDBI_FIRST + I;
		itoa(J, Number, 10);
		strcpy(Profile, "App#");
		strcat(Profile, Number);
		TIcons[I].Text = new char far[128];
		GetProfileString("SpeedManu", Profile, "Error", TIcons[I].Text , 128);
		if (strcmp(TIcons[I].Text, "Error") != 0)
		I++;
	  }

 RegisterClass((WNDCLASS*) &wndclass);
 Iconhwnd=CreateWindow(szIconBar,                  // WINDOW CLASS NAME
							  szIconBar,                  // WINDOW CAPTION
							  WS_POPUP|WS_BORDER,         // WINDOW STYLE
							  x,                          // INITIAL X POSITION
							  y,                          // INITIAL Y POSITION
							  150,                        // INITIAL X SIZE
							  2 + (18 * NICONS),          // INITIAL Y SIZE
							  NULL,                       // PARENT WINDOW HANDLE
							  NULL,                       // WINDOW MENU HANDLE
							  MainInstance,               // PROGRAM INSTANCE HANDLE
							  NULL);                      // CREATION PARAMETERS
 if (Iconhwnd)
	{
	 TempDC = GetDC(Iconhwnd);
	 // Create buttons
	 for (I = 0; I < NICONS; J++)
		  {
			if (strcmp(TIcons[I].Text, "Error") != 0)
				{
				 p = strchr(TIcons[I].Text, ',');
				 *p = 0x0;
				 Unit = GetTextExtent(TempDC, TIcons[I].Text, strlen(TIcons[I].Text));
				 if (BarLength < LOWORD(Unit))
					 BarLength = LOWORD(Unit);
				 I++;
				}
		  }
	 BarLength+=26;

	 for (I = 0; I < NICONS; J++)
		  {
			if (strcmp(TIcons[I].Text, "Error") != 0)
				{
				 TIcons[I].hwnd = CreateButton(Iconhwnd, TIcons[I].Text, 0, I * 18);
				 I++;
				}
		  }
	 ReleaseDC(Iconhwnd, TempDC);
	 MoveWindow(Iconhwnd, x, y, BarLength, 2 + (18 * NICONS), TRUE);
	 ShowWindow(Iconhwnd, SW_NORMAL);
	 return TRUE;
	}

 return FALSE;
}

long FAR PASCAL _export IconWndProc(HWND hwnd,UINT message,UINT wParam,LONG lParam)
{
 static HICON Icons[MAXICONS];
 static HDC DCMEM, DCMEM2;
 static Unactive = FALSE;
 int OldMode;
 int I, J;
 BOOL Destroy;
 LPDRAWITEMSTRUCT lpdis;
 RECT r;
 HBITMAP NewBitmap, OldBitmap;

  switch (message)
         {
			 case WM_CREATE:
               BarActive = TRUE;

			 case WM_DRAWITEM:
					{
					 lpdis = (LPDRAWITEMSTRUCT) lParam;

					 J = 0;
					 // get the current selected item
					 for (I = 0; I < NICONS; I++)
						  if (TIcons[I].hwnd == lpdis->hwndItem)
							  J = I;


					 // Extract the icon from Speedm.exe
					 Icons[J] = ExtractIcon(MainInstance, _argv[0], J);

					 DCMEM2  = GetDC(IconParent);
					 // Save the old mapping mode the set a new one to MM_TEXT
					 SelectObject(DCMEM2, GetStockObject(WHITE_BRUSH));
					 OldMode = SetMapMode(DCMEM2, MM_TEXT);

					 Rectangle(DCMEM2, 0, 0, 32, 32);

					 // Draw the icon into a temporary DC
					 DrawIcon(DCMEM2, 0, 0, Icons[J]);

					 // Create a compatible bitmap to shrink the icon
					 NewBitmap = CreateCompatibleBitmap(DCMEM2, 32, 32);

					 // Select the bitmap
					 OldBitmap = SelectObject(DCMEM2, NewBitmap);

					 // reset the old mapping mode
					 OldMode = SetMapMode(DCMEM2, OldMode);

					 // then display the shrunk icon
					 StretchBlt(                          // Shrink the bitmap to the destination
								lpdis->hDC,
								1,
								1,
								16,
								16,
								DCMEM2,
								0,
								0,
								32,
								32,
								SRCCOPY);

					 // Cleaning...
					 SelectObject(DCMEM2, OldBitmap);
					 DeleteObject(NewBitmap);
					 GetClientRect(IconParent, &r);

					 ReleaseDC(IconParent, DCMEM2);
					 // Draw the other part of the button 3D
					 SelectObject(lpdis->hDC, GetStockObject(LTGRAY_BRUSH));
					 SetBkColor(lpdis->hDC, RGB(192, 192, 192));
					 // Here I should put a relative data depending on the length of the largest string
					 Rectangle(lpdis->hDC, 19, 0, BarLength-2, 18);
					 SelectObject(lpdis->hDC, GetStockObject(WHITE_PEN));

					 // Draw the button and the text
					 if (lpdis->itemState & ODS_SELECTED)
						 {
						  MoveTo(lpdis->hDC, BarLength-2, 0);
						  LineTo(lpdis->hDC, BarLength-2, 17);
						  LineTo(lpdis->hDC, 20, 17);
						 }
					 else
						 {
						  MoveTo(lpdis->hDC, 20, 17);
						  LineTo(lpdis->hDC, 20, 0);
						  LineTo(lpdis->hDC, BarLength-2, 0);
						 }
					 TextOut(lpdis->hDC,22, 1, TIcons[J].Text, _fstrlen(TIcons[J].Text));
					 return TRUE;
					}

			 // if a button is clicked then notify the parent
			 case WM_COMMAND:
					if (HIWORD(wParam) == BN_CLICKED)
						{
						 Unactive = TRUE;
                   for (I = 0; I < NICONS; I++)
									if (TIcons[I].hwnd == (HWND) LOWORD(lParam))
                                         PostMessage(IconParent, WM_COMMAND, TIcons[I].ID, 0);
                   DestroyWindow(hwnd);
                   return TRUE;
						} break;

			 case WM_KILLFOCUS:
                  {
						 Destroy = TRUE;
                   for (I = 0; I < NICONS; I++)
							  if (TIcons[I].hwnd == (HWND) wParam)
                          Destroy = FALSE;
                   if (Destroy)
                      DestroyWindow(hwnd);
						 return TRUE;
                  }
          case WM_ACTIVATE:
                  if (!Unactive)
							if (wParam==0)
                        {
                         Unactive = TRUE;
                         DestroyWindow(hwnd);
                         SetActiveWindow(Active);
                        }
                  break;

			 case WM_DESTROY:
						for (I = 0; I < NICONS; I++)
                      {
                       delete TIcons[I].Text;
                       TIcons[I].Text = NULL;
							  TIcons[I].ID = 0;
                       DestroyIcon(Icons[I]);
                       DestroyWindow(TIcons[I].hwnd);
                       Unactive = FALSE;
                      }
						BarActive = FALSE;
                  PostMessage(IconParent, WM_USER + WM_DRAW, GetActiveWindow(), 0);
                  break;
					 }
 return(DefWindowProc(hwnd,message,wParam,lParam));
}


HWND CreateButton(HWND Parent, LPSTR Text, int x, int y)
{
 HWND hwndButton = CreateWindow(
			"BUTTON",  // predefined class
			Text,      // button text
			WS_VISIBLE | WS_CHILD | BS_OWNERDRAW, // styles

			x,         // starting x position
			y,         // starting y position

			BarLength, // button width
			18,        // button height
			Parent,    // parent window
			NULL,      // No menu
			MainInstance,
			NULL);     // pointer not needed

		  if (hwndButton)
			 {
					 ShowWindow(hwndButton, SW_NORMAL);
					 return hwndButton;
			 }
 return NULL;
}

