/*****************************************************************************
 *                                                                           *
 *                                  NET.CPP                                  *
 *---------------------------------------------------------------------------*
 *  First version:  11/18/1994                                               *
 *  Latest release: 11/18/1994                                               *
 *---------------------------------------------------------------------------*
 *  By Emmanuel Thioux //1994                                                *
 *                                                                           *
 *****************************************************************************/

// Include all the files we are going to use
#include <Windows.h>
#include <string.h>
#include "Hook.h"
#include <memory.h>

// Window proc functions
                           
extern NetConnectionDialog WNetConnectionDialog;
extern NetDisconnectDialog WNetDisconnectDialog;
extern NetShareAsDialog    WNetShareAsDialog;
extern NetStopShareDialog  WNetStopShareDialog;
                           
                           
HBITMAP Connect, DisConnect, Share, StopShare;
HMENU   PopupMenu;
HANDLE  NetLib;

BOOL NetFuncs(HWND _Parent, int x, int y)
{
 FARPROC Proc;
 
 Connect    = LoadBitmap(MainInstance, MAKEINTRESOURCE(2000));
 DisConnect = LoadBitmap(MainInstance, MAKEINTRESOURCE(2001));
 Share      = LoadBitmap(MainInstance, MAKEINTRESOURCE(2002));
 StopShare  = LoadBitmap(MainInstance, MAKEINTRESOURCE(2003));
 
 if ((NetLib = LoadLibrary("wfwnet.drv"))<32)
    {
     SendMessage(_Parent, WM_USER + WM_ERROR, NETERROR, 0);
     return 0;
    }
 Proc = GetProcAddress(NetLib, "WNETCONNECTIONDIALOG");
 WNetConnectionDialog = (NetConnectionDialog) MakeProcInstance(Proc, NetLib);
 Proc = GetProcAddress(NetLib, "WNETDISCONNECTDIALOG");
 WNetDisconnectDialog = (NetDisconnectDialog) MakeProcInstance(Proc, NetLib);
 Proc = GetProcAddress(NetLib, "WNETSHAREASDIALOG");
 WNetShareAsDialog = (NetShareAsDialog) MakeProcInstance(Proc, NetLib);
 Proc = GetProcAddress(NetLib, "WNETSTOPSHAREDIALOG");
 WNetStopShareDialog = (NetStopShareDialog) MakeProcInstance(Proc, NetLib);
 
 PopupMenu = CreatePopupMenu();
 AppendMenu(PopupMenu, MF_BITMAP, IDM_CONNECT, (LPCSTR) Connect);
 AppendMenu(PopupMenu, MF_BITMAP, IDM_DISCONNECT, (LPCSTR) DisConnect);
 AppendMenu(PopupMenu, MF_BITMAP, IDM_SHARE, (LPCSTR) Share);
 AppendMenu(PopupMenu, MF_BITMAP, IDM_STOPSHARE, (LPCSTR) StopShare);
 TrackPopupMenu(PopupMenu,TPM_LEFTALIGN|TPM_LEFTBUTTON, x, y,0,_Parent,NULL);
 return TRUE;
}
 
BOOL DestroyNet()
{
 DeleteObject(Connect);
 DeleteObject(DisConnect);
 DeleteObject(Share);
 DeleteObject(StopShare);
 FreeLibrary(NetLib);
 return TRUE;
}

