/*
**  FPTR_ADD.C
**
**  Add any add any value to a far pointer and returns the result as a
**  normalized far pointer.
**
**  Public Domain by Soleil Lapierre
*/

#if defined(__WATCOMC__)
 #include <i86.h>
#else
 #include <dos.h>
#endif

#ifdef __TURBOC__
 #define FAR far
#else
 #define FAR _far
#endif

#ifndef MK_FP
 #define MK_FP(seg,offset) \
        ((void FAR *)(((unsigned long)(seg)<<16) | (unsigned)(offset)))
#endif


char FAR *addptr (char FAR *p, unsigned long num)
{
      unsigned seg,off;
 
      seg = FP_SEG(p); off = FP_OFF(p);
      seg += off>>4;   off &= 0x000F;

      off += (unsigned)(num&0x0000000fL);

      seg += off>>4;   off &= 0x000F;
      seg += (unsigned)num>>4;

      return(MK_FP(seg,off));
}
