//  Header:     String  (Dynamic Strings)
//  Version:    2.01    26-Oct-1989
//
//  Language:   C++ 2.0
//  Environ:    Any
//  Compilers:  Zortech C++ 2.01
//
//  Purpose:    Provides a general dynamic string class.
//
//  Written by: Scott Robert Ladd
//              705 West Virginia
//              Gunnison CO 81230
//
//              MCI ID:  srl
//              FidoNet: 1:104/708

#if !defined(__STRING_HPP)
#define __STRING_HPP 1

#include "stream.hpp"
#include "stddef.h"

enum StrCompVal  {SC_LESS, SC_EQUAL, SC_GREATER};
enum StrCompMode {SM_SENSITIVE, SM_IGNORE};
enum StrError    {SE_ALLOC, SE_TOO_LONG};

class String
    {
    private:
        // instance variables
        unsigned int Siz;    // allocated size
        unsigned int Len;    // current length
        char * Txt;          // pointer to text

        // class constant
        static unsigned int AllocIncr;

        // pointer to exception handler
        static void (* ErrorHandler)(StrError);

        // private method used to shrink a string to its minimum allocation
        void Shrink();

    public:
        // constructor
        String();
        String(const String & Str);
        String(char * Cstr);
        String(char FillCh, unsigned int Count);

        // destructor
        ~String();

        // value return methods
        unsigned int Length();
        unsigned int Size();

        // Assign an exception handler
        static void SetErrorHandler(void (* UserHandler)(StrError));

        // Function to return a blank string
        friend String Empty();

        // copy String to c-string method
        void Copy(char * Cstr, unsigned int Max);

        // create a c-string from String method
        char * Dupe();

        // assignment method
        void operator = (const String & Str);

        // concatenation methods
        friend String operator + (const String & Str1, const String & Str2);
        void operator += (const String & Str);

        // comparison methods
        int operator <  (const String & Str);
        int operator >  (const String & Str);
        int operator <= (const String & Str);
        int operator >= (const String & Str);
        int operator == (const String & Str);
        int operator != (const String & Str);

        StrCompVal Compare(const String & Str, StrCompMode Case = SM_IGNORE);

        // substring search methods
        int Find(const String & Str, unsigned int & Pos, StrCompMode Case = SM_IGNORE);

        // substring deletion method
        void Delete(unsigned int Pos, unsigned int Count);

        // substring insertion methods
        void Insert(unsigned int Pos, char Ch);
        void Insert(unsigned int Pos, const String & Str);

        // substring retrieval method
        String SubStr(unsigned int Start, unsigned int Count);

        // character retrieval method
        char operator [] (unsigned int Pos);

        // case-modification methods
        String ToUpper();
        String ToLower();

        // stream I/O methods
        friend istream & operator >> (istream & Input,  const String & Str);
        friend ostream & operator << (ostream & Output, const String & Str);
    };


#endif //__STRING_HPP
