//----------------------------------------------------------------------------
//    MicroHelp Slider Example
//----------------------------------------------------------------------------

#include <mem.h>

#include <owl\applicat.h>
#include <owl\checkbox.h>
#include <owl\dc.h>
#include <owl\edit.h>
#include <owl\framewin.h>
#include <owl\owlpch.h>
#include <owl\point.h>
#include <owl\radiobut.h>

#include "slider.h"
#include "slider.rh"

const char   AppName[] = "Slider"; // Name of app, window title & icon resource id

DEFINE_RESPONSE_TABLE2(TMyWindow,TWindow,TVbxEventHandler)
  EV_WM_SIZE,
END_RESPONSE_TABLE;

TMyWindow::TMyWindow( TWindow *parent, const char far *title )
{
  TWindow::Init( parent, title, 0 );
  // IDC_Slider defined the in slider.rh ( Resource Header )
  // Use the form data to ensure correct dynamic creation
  mySlider = new TVbxMhSlide( this, IDC_Slider, "Slider",
				  0, 0, 0, 0, sizeof(MhSlideData), MhSlideData );
}

TMyWindow::~TMyWindow()
{
	delete mySlider;
}

void TMyWindow::SetupWindow()
{
  // We do our window-related work here, since in the constructor
  // the actual window has not been created yet.

  TRect rect;

  TWindow::SetupWindow();
  TWindow parent( GetParent( ) );  // get the parent
  //  Change the control to the horizontal style
  mySlider->SetPropStyle( TVbxMhSlide::Style_1_Horizontal );
  parent.GetClientRect( rect );    // get the size of the TFrameWindow
  // size the client to the TFrameWindow
  mySlider->MoveWindow( 0, 0, rect.Width(), rect.Height(), TRUE );
}

void TMyWindow::EvSize( UINT , TSize& size)
{
  //  This gets called when the client of the frame has been resized
  //  We call MoveWindow on the control to size it to the client
  mySlider->MoveWindow( 0, 0, size.cx, size.cy, TRUE );
}

class TSliderApp : public TApplication
{
  public:
	 TSliderApp(const char far* name) : TApplication(name) {}
	 ~TSliderApp() {  }
	 void   InitMainWindow();
};

void
TSliderApp::InitMainWindow()
{
  SetMainWindow( new TFrameWindow((TWindow *)0, Name, new TMyWindow(0,"Slider"), FALSE ));

  GetMainWindow()->SetIcon(this, AppName);
}

int
OwlMain(int /*argc*/, char* /*argv*/ [])
{
  //  Contructor of TBIVbxLibrary calls VBXInit( hInst, "Thunder" );
  //  Destructor calls VBXTerm();

  TBIVbxLibrary VbxLib;

  TSliderApp    App(AppName);
  return App.Run();
}
