// slidevw.cpp : implementation of the CSlidetestView class
//

#include "stdafx.h"
#include "slidetest.h"

#include "slidedoc.h"
#include "slidevw.h"
#include "CHSlider.h"
#include "CVSlider.h"
#include "movedlg.h"
#include "wborderd.h"
#include "innerdlg.h"
#include "outerwid.h"
#include "rangedlg.h"
#include "thumbdlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSlidetestView

IMPLEMENT_DYNCREATE(CSlidetestView, CView)

BEGIN_MESSAGE_MAP(CSlidetestView, CView)
	//{{AFX_MSG_MAP(CSlidetestView)
	ON_COMMAND(IDM_SLIDER_MOVE, OnSliderMove)
	ON_CONTROL(SCN_THUMBUP, ID_VSLIDER, OnSliderPosChanged)
	ON_COMMAND(IDM_NORMAL, OnNormal)
	ON_COMMAND(IDM_REVERSE, OnReverse)
	ON_UPDATE_COMMAND_UI(IDM_NORMAL, OnUpdateNormal)
	ON_UPDATE_COMMAND_UI(IDM_REVERSE, OnUpdateReverse)
	ON_COMMAND(IDM_BORDER, OnBorder)
	ON_COMMAND(IDM_INNER_BEVEL, OnInnerBevel)
	ON_COMMAND(IDM_OUTER_BEVEL, OnOuterBevel)
	ON_COMMAND(IDM_INNER_NONE, OnInnerNone)
	ON_COMMAND(IDM_INNER_INSET, OnInnerInset)
	ON_COMMAND(IDM_INNER_RAISED, OnInnerRaised)
	ON_COMMAND(IDM_INNER_FRAME, OnInnerFrame)
	ON_UPDATE_COMMAND_UI(IDM_INNER_NONE, OnUpdateInnerNone)
	ON_UPDATE_COMMAND_UI(IDM_INNER_INSET, OnUpdateInnerInset)
	ON_UPDATE_COMMAND_UI(IDM_INNER_RAISED, OnUpdateInnerRaised)
	ON_UPDATE_COMMAND_UI(IDM_INNER_FRAME, OnUpdateInnerFrame)
	ON_COMMAND(IDM_OUTER_NONE, OnOuterNone)
	ON_UPDATE_COMMAND_UI(IDM_OUTER_NONE, OnUpdateOuterNone)
	ON_UPDATE_COMMAND_UI(IDM_OUTER_INSET, OnUpdateOuterInset)
	ON_COMMAND(IDM_OUTER_INSET, OnOuterInset)
	ON_COMMAND(IDM_OUTER_RAISED, OnOuterRaised)
	ON_UPDATE_COMMAND_UI(IDM_OUTER_RAISED, OnUpdateOuterRaised)
	ON_UPDATE_COMMAND_UI(IDM_OUTER_FRAME, OnUpdateOuterFrame)
	ON_COMMAND(IDM_OUTER_FRAME, OnOuterFrame)
	ON_COMMAND(IDM_TICK_NORMAL, OnTickNormal)
	ON_COMMAND(IDM_TICK_INSET, OnTickInset)
	ON_COMMAND(IDM_TICK_RAISED, OnTickRaised)
	ON_UPDATE_COMMAND_UI(IDM_TICK_NORMAL, OnUpdateTickNormal)
	ON_UPDATE_COMMAND_UI(IDM_TICK_INSET, OnUpdateTickInset)
	ON_UPDATE_COMMAND_UI(IDM_TICK_RAISED, OnUpdateTickRaised)
	ON_MESSAGE(WM_CTLCOLORBTN, OnGetButtonColor)
	ON_COMMAND(IDM_SET_RANGE, OnSetRange)
	ON_COMMAND(IDM_SET_POS, OnSetPos)
	ON_COMMAND(IDM_BITMAP_BACK, OnBitmapBack)
	ON_COMMAND(IDM_BITMAP_THUMB, OnBitmapThumb)
	ON_UPDATE_COMMAND_UI(IDM_BITMAP_THUMB, OnUpdateBitmapThumb)
	ON_UPDATE_COMMAND_UI(IDM_BITMAP_BACK, OnUpdateBitmapBack)
	ON_COMMAND(IDM_BITMAP_FOCUS, OnBitmapFocus)
	ON_UPDATE_COMMAND_UI(IDM_BITMAP_FOCUS, OnUpdateBitmapFocus)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

/////////////////////////////////////////////////////////////////////////////
// CSlidetestView construction/destruction

CSlidetestView::CSlidetestView()
{
	m_pSlider = new CVSlider(50, 50, 45, 100);
	m_pSlider->UseLeftTicks(TRUE);
	m_pSlider->UseRightTicks(TRUE);
	
	m_pShowHorizontal = new CHSlider();
}

CSlidetestView::~CSlidetestView()
{
	delete m_pSlider;
	delete m_pShowHorizontal;
}

/////////////////////////////////////////////////////////////////////////////
// CSlidetestView drawing

void CSlidetestView::OnDraw(CDC* pDC)
{
	CSlidetestDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
}

/////////////////////////////////////////////////////////////////////////////
// CSlidetestView diagnostics

#ifdef _DEBUG
void CSlidetestView::AssertValid() const
{
	CView::AssertValid();
}

void CSlidetestView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CSlidetestDoc* CSlidetestView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CSlidetestDoc)));
	return (CSlidetestDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CSlidetestView message handlers


BOOL CSlidetestView::Create(LPCTSTR lpszClassName, LPCTSTR lpszWindowName, DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID, CCreateContext* pContext) 
{
	// TODO: Add your specialized code here and/or call the base class
	BOOL bRet = CWnd::Create(lpszClassName, lpszWindowName, dwStyle, rect, pParentWnd, nID, pContext);
	
	if (bRet)
	{
		m_pSlider->Create(this, ID_VSLIDER, 0, 100, 20);
		bRet &= m_pSlider->IsValid();
		m_pShowHorizontal->Create(this, ID_HSLIDER, 0, 100, 20);
	}

	return bRet;
}

void CSlidetestView::OnSliderPosChanged()
{
	CString csPos;
	csPos.Format("%d", m_pSlider->GetPos());
	GetDocument()->SetTitle(csPos);
}

void CSlidetestView::OnSliderMove() 
{
	MoveDlg dlg;
	RECT rect;
	m_pSlider->GetWindowRect(&rect);
	ScreenToClient(&rect);

	dlg.m_nX = rect.left;
	dlg.m_nY = rect.top;
	dlg.m_nWidth = (rect.right - rect.left);
	dlg.m_nHeight = (rect.bottom - rect.top);

	if (IDOK == dlg.DoModal())
	{
		rect.left = dlg.m_nX;
		rect.top = dlg.m_nY;
		rect.right = (rect.left + dlg.m_nWidth);
		rect.bottom = (rect.top + dlg.m_nHeight);
		m_pSlider->MoveWindow(&rect);
	}
}

void CSlidetestView::OnNormal() 
{
	m_pSlider->SetDirection(FALSE);
}

void CSlidetestView::OnReverse() 
{
	m_pSlider->SetDirection(TRUE);	
}

void CSlidetestView::OnUpdateNormal(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(!m_pSlider->GetDirection());	
}

void CSlidetestView::OnUpdateReverse(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(m_pSlider->GetDirection());	
}

void CSlidetestView::OnBorder() 
{
	WBorderd dlg;
	
	if (IDOK == dlg.DoModal())
	{
		m_pSlider->SetBorderWidth(dlg.m_nWidth);
	}	
}

void CSlidetestView::OnInnerBevel() 
{
	InnerDlg dlg;
	
	if (IDOK == dlg.DoModal())
	{
		m_pSlider->SetInnerBevelWidth(dlg.m_nWidth);
	}	
}

void CSlidetestView::OnOuterBevel() 
{
	OuterWidth dlg;
	
	if (IDOK == dlg.DoModal())
	{
		m_pSlider->SetOuterBevelWidth(dlg.m_nWidth);
	}	
}

void CSlidetestView::OnInnerNone() 
{
	m_pSlider->SetInnerBevelStyle(SCS_NONE);	
}

void CSlidetestView::OnInnerInset() 
{
	m_pSlider->SetInnerBevelStyle(SCS_INSET);
}

void CSlidetestView::OnInnerRaised() 
{
	m_pSlider->SetInnerBevelStyle(SCS_RAISED);
}

void CSlidetestView::OnInnerFrame() 
{
	m_pSlider->SetInnerBevelStyle(SCS_FRAME);
}

void CSlidetestView::OnUpdateInnerNone(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(SCS_NONE == m_pSlider->GetInnerBevelStyle());
}

void CSlidetestView::OnUpdateInnerInset(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(SCS_INSET == m_pSlider->GetInnerBevelStyle());
}

void CSlidetestView::OnUpdateInnerRaised(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(SCS_RAISED == m_pSlider->GetInnerBevelStyle());
}

void CSlidetestView::OnUpdateInnerFrame(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(SCS_FRAME == m_pSlider->GetInnerBevelStyle());
}

void CSlidetestView::OnOuterNone() 
{
	m_pSlider->SetOuterBevelStyle(SCS_NONE);
}

void CSlidetestView::OnOuterInset() 
{
	m_pSlider->SetOuterBevelStyle(SCS_INSET);
}

void CSlidetestView::OnOuterRaised() 
{
	m_pSlider->SetOuterBevelStyle(SCS_RAISED);
}

void CSlidetestView::OnOuterFrame() 
{
	m_pSlider->SetOuterBevelStyle(SCS_FRAME);
}

void CSlidetestView::OnUpdateOuterNone(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(SCS_NONE == m_pSlider->GetOuterBevelStyle());
}

void CSlidetestView::OnUpdateOuterInset(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(SCS_INSET == m_pSlider->GetOuterBevelStyle());
}

void CSlidetestView::OnUpdateOuterRaised(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(SCS_RAISED == m_pSlider->GetOuterBevelStyle());
}

void CSlidetestView::OnUpdateOuterFrame(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(SCS_FRAME == m_pSlider->GetOuterBevelStyle());
}

void CSlidetestView::OnTickNormal() 
{
	m_pSlider->SetTickStyle(SCTICK_NORMAL);
}

void CSlidetestView::OnTickInset() 
{
	m_pSlider->SetTickStyle(SCTICK_INSET);
}

void CSlidetestView::OnTickRaised() 
{
	m_pSlider->SetTickStyle(SCTICK_RAISED);
}

void CSlidetestView::OnUpdateTickNormal(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(SCTICK_NORMAL == m_pSlider->GetTickStyle());
}

void CSlidetestView::OnUpdateTickInset(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(SCTICK_INSET == m_pSlider->GetTickStyle());
}

void CSlidetestView::OnUpdateTickRaised(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(SCTICK_RAISED == m_pSlider->GetTickStyle());
}

LRESULT CSlidetestView::OnGetButtonColor(WPARAM wParam, LPARAM lParam)
{
	//We must tell the slider what color to use for it's face
	if ((ID_VSLIDER == ::GetWindowLong((HWND) lParam, GWL_ID)) ||
		(ID_HSLIDER == ::GetWindowLong((HWND) lParam, GWL_ID)))
	{
		::SetBkColor((HDC) wParam, GetSysColor(COLOR_BTNFACE));
		return TRUE;
	}
	
	return FALSE;
}

void CSlidetestView::OnSetRange() 
{
RangeDlg dlg;

	long lRange = m_pSlider->GetRange();

	dlg.m_nMin = (short) LOWORD(lRange);
	dlg.m_nMax = (short) HIWORD(lRange);

	if (IDOK == dlg.DoModal())
	{
		lRange = MAKELONG(short(dlg.m_nMin), short(dlg.m_nMax));
		m_pSlider->SetRange(lRange);
	}
}

void CSlidetestView::OnSetPos() 
{
ThumbDlg dlg;

	dlg.m_nPos = m_pSlider->GetPos();

	if (IDOK == dlg.DoModal())
	{
		m_pSlider->SetPos((short) dlg.m_nPos);
		CString cs;
		cs.Format("%d", dlg.m_nPos);
		GetDocument()->SetTitle(cs);
	}
}

void CSlidetestView::OnBitmapBack() 
{
	if (TRUE == m_pSlider->IsBackBitmapSet())
	{
		m_pSlider->SetBackBitmap(0);
	}
	else
	{
		m_pSlider->SetBackBitmap(IDB_VERT_BACK);
	}
}

void CSlidetestView::OnBitmapThumb() 
{
	if (TRUE == m_pSlider->IsThumbBitmapSet())
	{
		m_pSlider->SetThumbBitmap(0);
	}
	else
	{
		m_pSlider->SetThumbBitmap(IDB_VERT_THUMB);
	}
}

void CSlidetestView::OnBitmapFocus() 
{
	if (TRUE == m_pSlider->IsFocusBitmapSet())
	{
		m_pSlider->SetFocusBitmap(0);
	}
	else
	{
		m_pSlider->SetFocusBitmap(IDB_VERT_FOCUS);
	}
}

void CSlidetestView::OnUpdateBitmapThumb(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(m_pSlider->IsThumbBitmapSet());
}

void CSlidetestView::OnUpdateBitmapBack(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(m_pSlider->IsBackBitmapSet());
}

void CSlidetestView::OnUpdateBitmapFocus(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(m_pSlider->IsFocusBitmapSet());
}
