/***************************************************************

   Copyright 1993-95  Northeast Data Corp.  All Rights Reserved

****************************************************************/

/***************************************************************


   CVSlider.cpp

   Class implementation for MFC applications that use the Vertical slider.
   Version 3.0, November 1994, Wade Cobb & Paul King

****************************************************************/

#include "stdafx.h"
#include "CVSlider.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

//Constructor used for arrays with default values
//If this contructor is used, the user must move the windows
//To see them
CVSlider::CVSlider() : CSlider(0,0,45,100, SCS_VERTICAL)
{
	UseLeftTicks(TRUE);
	UseRightTicks(TRUE);
}

CVSlider::CVSlider(int nX, int nY, int nWidth, int nHeight) :
	CSlider(nX, nY, nWidth, nHeight, SCS_VERTICAL)
{
}

CVSlider::~CVSlider()
{
}

void CVSlider::UseLeftTicks(BOOL bUse)
{
	if (bUse)
	{
		m_dwStyle |= SCS_LEFTTICKS;
	}
	else
	{
		m_dwStyle &= ~SCS_LEFTTICKS;
	}
}

void CVSlider::UseRightTicks(BOOL bUse)
{
	if (bUse)
	{
		m_dwStyle |= SCS_RIGHTTICKS;
	}
	else
	{
		m_dwStyle &= ~SCS_RIGHTTICKS;
	}
}
