/***************************************************************

   Copyright 1993-95  Northeast Data Corp.  All Rights Reserved

****************************************************************/

/***************************************************************


   CHSlider.cpp

   Class implementation for MFC applications that use the Horizontal slider.
   Version 3.0, November 1994, Wade Cobb & Paul King

****************************************************************/


#include "stdafx.h"
#include "CHSlider.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

//Constructor used for arrays with default values
//If this contructor is used, the user must move the windows
//To see them
CHSlider::CHSlider() : CSlider(0,0,100,45, SCS_HORIZONTAL)
{
	UseTopTicks(TRUE);
	UseBottomTicks(TRUE);
}

CHSlider::CHSlider(int nX, int nY, int nWidth, int nHeight) :
	CSlider(nX, nY, nWidth, nHeight, SCS_HORIZONTAL)
{
}

CHSlider::~CHSlider()
{
}

void CHSlider::UseTopTicks(BOOL bUse)
{
	if (bUse)
	{
		m_dwStyle |= SCS_TOPTICKS;
	}
	else
	{
		m_dwStyle &= ~SCS_TOPTICKS;
	}
}

void CHSlider::UseBottomTicks(BOOL bUse)
{
	if (bUse)
	{
		m_dwStyle |= SCS_BOTTOMTICKS;
	}
	else
	{
		m_dwStyle &= ~SCS_BOTTOMTICKS;
	}
}
