/****************************************************************

	as_focus.c      Orbital focus routines
			for astronomy (as) subsystem

			Copyright (c) 1991, Ted A. Campbell

			Bywater Software
			P. O. Box 4023 
			Duke Station 
			Durham, NC  27706

			email: tcamp@hercules.acpub.duke.edu

	Copyright and Permissions Information:

	All U.S. and international copyrights are claimed by the
	author. The author grants permission to use this code
	and software based on it under the following conditions:
	(a) in general, the code and software based upon it may be 
	used by individuals and by non-profit organizations; (b) it
	may also be utilized by governmental agencies in any country,
	with the exception of military agencies; (c) the code and/or
	software based upon it may not be sold for a profit without
	an explicit and specific permission from the author, except
	that a minimal fee may be charged for media on which it is
	copied, and for copying and handling; (d) the code must be 
	distributed in the form in which it has been released by the
	author; and (e) the code and software based upon it may not 
	be used for illegal activities. 

****************************************************************/

#include "stdio.h"
#include "ctype.h"
#include "bw.h"
#include "as.h"

#ifdef __STDC__
#include "malloc.h"
#else
extern char * malloc();
#endif

#define CHECK_PARAMS

/****************************************************************

	as_readfd()     read a focal data (fd) file

****************************************************************/

as_readfd( fdfile, fstruct )
   char *fdfile;
   struct as_focus *fstruct;
   {
   FILE *data;                          /* data file for read */
   register int c;                      /* counter */
   static char x_buffer[ BW_EBUFSIZE ]; /* buffer to read data */
   char *r;                             /* return value from as_fgets */

   /* Send notice */

   sprintf( bw_ebuf, "Reading focal datafile %s",
      fdfile );
   bw_message( bw_ebuf );

   /***  Try to open the file, return for failure */

   if ( ( data = fopen( fdfile, "rb" )) == NULL )
      {
      sprintf( bw_ebuf, "Cannot open focal data file %s",
	 fdfile );
      bw_error( bw_ebuf );
      return BW_ERROR;
      }

   /***  Begin reading elements from the file */
   /***  0. save fd filename itself */

   /* allocate memory for name */

   if ( ( fstruct->fdfile = malloc( strlen( fdfile ) + 2 )) == NULL )
      {
      bw_error( "Failed to allocate memory for fd filename. " );
      return BW_ERROR;                          /* error return */
      }
   strcpy( fstruct->fdfile, fdfile );

   /***  1. Read name of the focus */

   r = as_fgets( x_buffer, 127, data );         /* get a string */
   if ( r == NULL )
      {
      sprintf( bw_ebuf, "Failure to read focal data file %s ", fdfile );
      bw_error( bw_ebuf );
      return BW_ERROR;
      }

#ifdef OLD_DEBUG
   fprintf( stderr, "DEBUG: read name \n" );
#endif

   for ( c = 0; x_buffer[ c ] >= ' '; ++c )     /* find end of string */
      {

#ifdef OLD_DEBUG
   fprintf( stderr, "DEBUG: counting: %3d [char 0x%3x next 0x%3x] \n", 
      c, x_buffer[ c ], x_buffer[ c + 1 ]  );
#endif

      }
   x_buffer[ c ] = 0;                           /* terminate with 0 */

   /* allocate memory for name */

   if ( ( fstruct->name = malloc( strlen( x_buffer ) + 2 )) == NULL )
      {
      bw_error( "Failed to allocate memory for focal data elements. " );
      return BW_ERROR;                          /* error return */
      }

#ifdef OLD_DEBUG
   fprintf( stderr, "DEBUG: allocated memory \n" );
#endif

   strcpy( fstruct->name, x_buffer );           /* copy name to buffer */

#ifdef OLD_DEBUG
   fprintf( stderr, "DEBUG: copied name to buffer \n" );
#endif

   /***  2. Read adjective for the focus */

   r = as_fgets( x_buffer, 127, data );        /* get a string */
   if ( r == NULL )
      {
      sprintf( bw_ebuf, "Failure to read focal data file %s ", fdfile );
      bw_error( bw_ebuf );
      return BW_ERROR;
      }

#ifdef OLD_DEBUG
   fprintf( stderr, "DEBUG: read adjective \n" );
#endif

   for ( c = 0; x_buffer[ c ] >= ' '; ++c )    /* find end of string */
      {

#ifdef OLD_DEBUG
   fprintf( stderr, "DEBUG: counting: %2d [char 0x%2x next 0x%2x] \n",
      c, x_buffer[ c ], x_buffer[ c + 1 ]  );
#endif

      }

#ifdef OLD_DEBUG
   fprintf( stderr, "DEBUG: count complete; c = %d \n", c );
#endif

   x_buffer[ c ] = 0;                          /* terminate with 0 */

#ifdef OLD_DEBUG
   fprintf( stderr, "DEBUG: buffer terminated \n" );
#endif

   /* allocate memory for adjective */

   if ( ( fstruct->adjective = malloc( strlen( x_buffer ) + 2 )) == NULL )
      {
      bw_error( "Failed to allocate memory for focal data elements. " );
      return BW_ERROR;                          /* error return */
      }

#ifdef OLD_DEBUG
   fprintf( stderr, "DEBUG: allocated memory \n" );
#endif

   strcpy( fstruct->adjective, x_buffer );      /* copy adjective to buffer */

#ifdef OLD_DEBUG
   fprintf( stderr, "DEBUG: copied adjective \n" );
#endif

   /***  3. Read radius of the focus */

   r = as_fgets( x_buffer, 127, data );
   if ( r == NULL )
      {
      sprintf( bw_ebuf, "Failure to read focal data file %s ", fdfile );
      bw_error( bw_ebuf );
      return BW_ERROR;
      }

#ifdef OLD_DEBUG
   fprintf( stderr, "DEBUG: read radius \n" );
#endif

   sscanf( x_buffer, "%lf", &fstruct->radius );

#ifdef OLD_DEBUG
   fprintf( stderr, "DEBUG: scanned radius \n" );
#endif

   /***  4. Read mass of the focus */

   r = as_fgets( x_buffer, 127, data );
   if ( r == NULL )
      {
      sprintf( bw_ebuf, "Failure to read focal data file %s ", fdfile );
      bw_error( bw_ebuf );
      return BW_ERROR;
      }

#ifdef OLD_DEBUG
   fprintf( stderr, "DEBUG: read mass \n" );
#endif

   sscanf( x_buffer, "%lf", &fstruct->mass );

#ifdef OLD_DEBUG
   fprintf( stderr, "DEBUG: scanned mass \n" );
#endif

   fstruct->mass *= 5.98e27;

   /***  5. Read sidereal period of the focus */

   r = as_fgets( x_buffer, 127, data );
   if ( r == NULL )
      {
      sprintf( bw_ebuf, "Failure to read focal data file %s ", fdfile );
      bw_error( bw_ebuf );
      return BW_ERROR;
      }

#ifdef OLD_DEBUG
   fprintf( stderr, "DEBUG: read sidereal period \n" );
#endif

   sscanf( x_buffer, "%lf", &fstruct->sid_day );

#ifdef OLD_DEBUG
   fprintf( stderr, "DEBUG: scanned sidereal period \n" );
#endif

   fclose( data );                              /* close the fd file */

   }


