/***************************************************************

	ui.h            Header file for User Interface
			implementation

			Copyright (c) 1991, Ted A. Campbell

			Bywater Software
			P. O. Box 4023 
			Duke Station 
			Durham, NC  27706

			email: tcamp@hercules.acpub.duke.edu

	Copyright and Permissions Information:

	All U.S. and international copyrights are claimed by the
	author. The author grants permission to use this code
	and software based on it under the following conditions:
	(a) in general, the code and software based upon it may be 
	used by individuals and by non-profit organizations; (b) it
	may also be utilized by governmental agencies in any country,
	with the exception of military agencies; (c) the code and/or
	software based upon it may not be sold for a profit without
	an explicit and specific permission from the author, except
	that a minimal fee may be charged for media on which it is
	copied, and for copying and handling; (d) the code must be 
	distributed in the form in which it has been released by the
	author; and (e) the code and software based upon it may not 
	be used for illegal activities. 

***************************************************************/

/* some ASCII control character constants */

#ifndef CR
#define CR      0x0d
#endif

#ifndef LF
#define LF      0x0a
#endif

#ifndef   ESCAPE
#define   ESCAPE   0x1b
#endif

/* user-controllable definitions for toolkit */

#define SHADOW_XSIZE    4
#define BORDER_SIZE     2
#define MAXENTRIES      64
#define MAXLENGTH       80
#define TITLE_YMARGIN   1
#define USE_ICONS
#define INC_ACCURACY    50   /* multiply by a larger number for accuracy */
#define DEFAULT_FONT_SIZE 30
#define BWENVARNAME     "BWPATH"        /* name for BW Path Env. variable */
#define UI_MEMERR       "Out of Memory"

/* menu types */

#define   MENU_PLAIN   0
#define   MENU_TITLED  1
#define   MENU_SLIDERS 2
#define   MENU_ICON    3

/* return values */

#define TK_ERROR        0xeffe
#define TK_EXIT         0xefff
#define MO_UP           0x501
#define MO_DN           0x502
#define MO_SEL          0x503
#define MO_EXIT         0x505
#define MO_LEFT         0x506
#define MO_RIGHT        0x507
#define MO_SRC          0x508

#define EVENT_NULL       0
#define	EVENT_SELECTED   1
#define EVENT_ERROR      0xeffe
#define EVENT_EXIT       0xefff
#define EVENT_SOURCE     2
#define EVENT_CHANGE     3

/* Window buttons */

#define BUT_CLOSE               1
#define BUT_MOVE                2
#define BUT_RESIZE              4


struct   uiwindow
   {
   int     x1;             /* left of whole area           */
   int     y1;             /* bottom of whole area         */
   int     x2;             /* right of whole area          */
   int     y2;             /* top of whole area            */
   int     t_flag;         /* is there a title ?           */
   int     t_bcolor;       /* title background color       */
   int     t_tcolor;       /* title text color             */
   int     tbar_x1;        /* left of title bar            */
   int     tbar_y1;        /* bottom of title bar          */
   int     tbar_x2;        /* right of title bar           */
   int     tbar_y2;        /* top of title bar             */
   int     ti_x1;          /* left side of title area    */
   int     ti_y1;          /* bottom of title area       */
   int     ti_x2;          /* right side of title area   */
   int     ti_y2;          /* top of title area          */
   int     s_flag;         /* is there a shadow?           */
   int     s_color;        /* shadow color                 */
   int     b_flag;         /* is there a border ?          */
   int     b_color;        /* border color                 */
   int     m_color;        /* main area color              */
   int     m_style;        /* main area fill style         */
   int     buttons;        /* buttons selected             */
   int     bt_x1;          /* left side of close button    */
   int     bt_y1;          /* bottom of close button       */
   int     bt_x2;          /* right side of close button   */
   int     bt_y2;          /* top of close button          */
   int     re_x1;          /* left side of resize button   */
   int     re_y1;          /* bottom of resize button      */
   int     re_x2;          /* right side of resize button  */
   int     re_y2;          /* top of resize button         */
   int     mv_x1;          /* left side of move button     */
   int     mv_y1;          /* bottom of move button        */
   int     mv_x2;          /* right side of move button    */
   int     mv_y2;          /* top of move button           */
   int     u_x1;           /* left of usable space         */
   int     u_y1;           /* bottom of usable space       */
   int     u_x2;           /* right of usable space        */
   int     u_y2;           /* top of usable space          */
   };

struct  menu_box
   {
   struct  uiwindow *window;       /* uiwindow for menu/icon box   */
   int     type;                   /* type of menu                 */
   char    **d_titles;             /* array of titles              */
   struct  dir_ent **d_entries;    /* array of directory entries   */
   int     max_entries;            /* max items in each array      */
   int     is_drawn;               /* is menu/icon box drawn?      */
   int     save_fysize;            /* save font y size             */
   int     save_font;              /* save font type               */
   int     xsize;                  /* x size of single icon space  */
   int     ysize;                  /* y size of single icon space  */
   int     x_items;                /* number of icons on x axis    */
   int     y_items;                /* number of icons on y axis    */
   int     x_logical;              /* logical items on x axis      */
   int     y_logical;              /* logical items on y axis      */
   int     x_pos;                  /* current position, x axis     */
   int     y_pos;                  /* current position, y axis     */
   int     current;                /* currently selected item      */
   int     x_start;                /* starting position for x axis */
   int     y_start;                /* starting position for y axis */
   int     fore;                   /* foreground color             */
   int     back;                   /* background color             */
   int     high;                   /* highlight color              */
   int     number;                 /* total number of icons/menu items */
   int     i_x1;                   /* icon area, left              */
   int     i_y1;                   /* icon area, bottom            */
   int     i_x2;                   /* icon area, right             */
   int     i_y2;                   /* icon area, top               */
   int     vs_x1;                  /* vertical slide, left         */
   int     vs_y1;                  /* vertical slide, bottom       */
   int     vs_x2;                  /* vertical slide, right        */
   int     vs_y2;                  /* vertical slide, top          */
   int     ve_y1;                  /* vertical elevator, bottom    */
   int     ve_y2;                  /* vertical elevator, top       */
   int     hs_x1;                  /* horizontal slide, left       */
   int     hs_y1;                  /* horizontal slide, bottom     */
   int     hs_x2;                  /* horizontal slide, right      */
   int     hs_y2;                  /* horizontal slide, top        */
   int     he_x1;                  /* horizontal elevator, left    */
   int     he_x2;                  /* horizontal elevator, right   */
   int     vel_x1;                 /* vertical elevator left       */
   int     vel_y1;                 /* vertical elevator bottom     */
   int     vel_x2;                 /* vertical elevator right      */
   int     vel_y2;                 /* vertical elevator top        */
   int     vel_inc;                /* vertical elevator increment  */
   int     hel_x1;                 /* horizontal elevator left     */
   int     hel_y1;                 /* horizontal elevator bottom   */
   int     hel_x2;                 /* horizontal elevator right    */
   int     hel_y2;                 /* horizontal elevator top      */
   int     hel_inc;                /* horizontal elevator increment */
   };

struct pbm_struct
   {
   int xsize;
   int ysize;
   int image;
   };

struct tty_struct
   {
   struct uiwindow *window;     /* pointer to ui window structure */
   int lines;                   /* text lines in window */
   int columns;                 /* text columns in window */
   int font_ysize;              /* font size, vertical */
   int font_xsize;              /* font size, horizontal */
   int curs_xpos;               /* cursor x (column) position */
   int curs_ypos;               /* cursor y (line) position */
   int foreground;              /* text foreground color */
   int background;              /* text background color */
   int standout;                /* boolean: standout? TRUE = reverse video */
   int scroll_right;            /* boolean: scroll at right margin */
				/* default: FALSE, do not scroll */
   char *cbuffer;               /* buffer to hold character position */
   };                           /* overwritten by cursor */

struct ui_twstruct
   {
   struct tw_struct *tw;
   struct uiwindow  *uiw;
   };

extern  struct gr_window *ui_grwind;
extern  char   ui_ready;

extern  struct uiwindow * ui_window();
extern  struct tty_struct * tty_init();
extern  struct ui_twstruct * ui_twinit();

extern  char ui_tbuf[ 128 ];
extern	int  ui_screen;
extern  char   ui_fontpath[ 128 ];

extern  struct pbm_struct ui_elicon;         /* elevator icon */
extern  struct pbm_struct ui_lefticn;        /* left icon */
extern  struct pbm_struct ui_righticn;       /* right icon */
extern  struct pbm_struct ui_upicn;          /* up icon */
extern  struct pbm_struct ui_downicn;        /* down icon */
extern  struct pbm_struct ui_clicon;         /* close window icon */
extern  struct pbm_struct ui_reicon;         /* resize window icon */
extern  struct pbm_struct ui_mvicon;         /* move window icon */
extern  struct pbm_struct ui_deficon;        /* default file icon */
extern  struct pbm_struct ui_foldicon;       /* file folder icon */
extern  struct pbm_struct ui_exicon;         /* executable file icon */
