//----------------------------------------------------------------------------
// CUSTOMIZED CURSOR
// Written by Glenn Caviness
// December 12, 1994
//----------------------------------------------------------------------------

#include <owl\owlpch.h>
#include <owl\applicat.h>
#include <owl\framewin.h>

#include <owl\dialog.h>
#include <owl\edit.h>

#include "setcurs.rh"     // menu, dialog box & cursor IDENTIFIERS

//////////////////////////////////////////////////////////////////////////

class MyDialog : public TDialog
{
  private:
     TEdit *edit;       // pointer to dialog's Name field

  public:
     MyDialog( TWindow* parent, int resId);
     ~MyDialog() {  delete edit;  };
     void SetupWindow();    // override to base class SetupWindow() function
};


//////////////////////////////////////////////////////////////////////////

class TMyWindow : public TWindow {
  public:
    TMyWindow(TWindow *parent = 0);
    ~TMyWindow()  {   };
    void SetupWindow();

//  protected:
    BOOL CanClose()  {    }; // Overrode member function of TWindow
                             //  to eliminate confirmation when
                             //  CloseWindow() is called

    // Message response functions
    void CmExitApp()  {    CloseWindow();   }
    void CmDialog();

    DECLARE_RESPONSE_TABLE(TMyWindow);
};

DEFINE_RESPONSE_TABLE1(TMyWindow, TWindow)
  EV_COMMAND(CM_EXITAPP, CmExitApp),
  EV_COMMAND(CM_DIALOG, CmDialog),
END_RESPONSE_TABLE;


//////////////////////////////////////////////////////////////////////////

TMyWindow::TMyWindow(TWindow *parent)
{
  Init(parent, 0, 0);
}

//////////////////////////////////////////////////////////////////////////

void TMyWindow::SetupWindow()
{
  SetCursor( GetModule(), CURSOR_1);
  // Set's cursor for this window
}

//////////////////////////////////////////////////////////////////////////

struct DlgData     // struct used to transfer data into/out of dialog box
{
   char name[15];
} dlgdata;

//////////////////////////////////////////////////////////////////////////

void TMyWindow::CmDialog()
{
   strcpy( dlgdata.name, "Smith");

   MyDialog *TPDD;
   TPDD = new MyDialog(this, DIALOG_1);      // set pointer to DialogBox Object
   TPDD->SetTransferBuffer(&dlgdata);        // Set transfer buffer
   TPDD->SetCursor( GetModule(), CURSOR_2);  // Set Cursor for Dialog
   TPDD->Execute();                          // Display (Execute) Dialog Box

   // constuct string to display info in a Message Box
   string msg =  ( dlgdata.name );
   ::MessageBox( NULL, msg.c_str(), " Data Retrieved from Dialog Box ", MB_OK);
}

//////////////////////////////////////////////////////////////////////////

MyDialog::
MyDialog( TWindow* parent, int resId)
  : TDialog(parent, resId),
    TWindow(parent)
{
  edit = new TEdit(this, IDC_NAME, 15);   // create object so can transfer
                                          //   data in/out of Dialog Box
}

//////////////////////////////////////////////////////////////////////////

void MyDialog::SetupWindow()
{
  TDialog::SetupWindow();
  // Could have SETCURSOR for this dialog box here HERE
  //    BUT we set cursor for this window w/
  //    TPDD->SetCursor( GetModule(), CURSOR_1)
  //    in void TMyWindow::CmDialog()
}

//////////////////////////////////////////////////////////////////////////

class TMyApp : public TApplication
{
  public:
    TMyApp() : TApplication() {}

    void InitMainWindow()
    {
      SetMainWindow(new TFrameWindow(0, "Custom Cursor Program", new TMyWindow));
      GetMainWindow()->AssignMenu(MAIN_MENU);
    }
};

//////////////////////////////////////////////////////////////////////////

int OwlMain(int /*argc*/, char* /*argv*/ [])
{
  return TMyApp().Run();
}

//////////////////////////////////////////////////////////////////////////


