//
//                          PROBLEM 2, CHAPTER 4
//							   LEARNING C++
//                            by NEILL GRAHAM
//
//							   Joe Hatfield
//                            CIS 72657,717
//                           October 31, 1991
//
//
// A set of integers, all in the range MIN through MAX, can be represented
// by a character array c of size MAX - MIN + 1; element c[i - MIN] is 1
// if i belongs to the set and 0 if it does not.
//
//
//              For MAX = 20 and MIN = 10, length = 11
//
//             the set { 13, 14, 18 } can be represented
//             by the following array c:
//
//		i		0	1	2	3	4	5	6	7	8	9	10
//           -----------------------------------------------
//    c[i]      0	0	0	1	1	0	0	0	1	0	0
//
//
// File ooset.h
// Header file for class ooset
//
//  Check for compiler
#	ifndef __BCPLUSPLUS__
#		error Must use BORLAND C++ Compiler
#	endif

//  Define ooset.h
#	ifndef __OOSET_H
#	define __OOSET_H

//  Define NULL
#	ifndef NULL
#		if defined(__TINY__) || defined(__SMALL__) || defined(__MEDIUM__)
#			define NULL	0
#		else
#			define NULL	0L
#		endif
#	endif

//  Define Class type
#	if defined(__SMALL__) || defined(__MEDIUM__)
#		define _CLASSTYPE near
#	elif  defined(__COMPACT__) || defined(__LARGE__)
#		define _CLASSTYPE far
#	else
#		define _CLASSTYPE hugh
#	endif

//  Check for includes
#	if !defined( __IOSTREAM_H )
#		include <iostream.h>
#	endif

#	if !defined( __STDLIB_H )
#		include <stdlib.h>
#	endif

# 	if !defined( __MEM_H )
#		include <mem.h>
#	endif

const MINIMUM = 10;
const MAXIMUM = 20;

enum BOOLEAN { FALSE, TRUE };

class _CLASSTYPE set
{
		char* ptr;		// Pointer to the array
		int min;        // The minimum range of the set
		int max;        // The maximum range of the set
		int len;        // The length of the array

	public:
		set();									// Empty set Constructor
		set( int num );							// Singleton set Constructor
		~set( void ) { delete ptr; }			// Set Destructor
		set( const set& s );          			// Copy set operator
		set& operator= ( const set& set_two );	// Assignment operator

		// Complement operator
		friend set operator- ( const set& s );

		// Difference operators
		friend set operator- ( const set& set_one, const set& set_two );
		set& operator-= ( const set& set_two );

		// Union operators
		friend set operator+ ( const set& set_one, const set& set_two );
		set& operator+= ( const set& set_two );

		// Intersection operators
		friend set operator* ( const set& set_one, const set& set_two );
		set& operator*= ( const set& set_two );

		// Equality operators
		friend BOOLEAN operator== ( const set& set_one, const set& set_two );
		friend BOOLEAN operator!= ( const set& set_one, const set& set_two );

		// Comparison operators
		friend BOOLEAN operator<  ( const set& set_one, const set& set_two );
		friend BOOLEAN operator>  ( const set& set_one, const set& set_two );
		friend BOOLEAN operator>= ( const set& set_one, const set& set_two );
		friend BOOLEAN operator<= ( const set& set_one, const set& set_two );

		// Output operator
		friend ostream& operator<< ( ostream& stream, const set& data );
};
#endif	// define __OOSET_H
