/*
 * CMOS.C -- test CMOS RAM functions of RTCHDW.C
 *
 * Sample MAKE file:
 *
 * .c.obj:
 *   bcc -c $<
 *
 * cmos.exe: cmos.obj rtchdw.obj
 *   bcc cmos.obj rtchdw.obj
 */
#include <stdio.h>
#include "rtc.h"

void main (void) {
  int x,y,Loc,Data;

  printf ("\n%33s\n\n  ", "CMOS RAM Dump");
  for (x = 0; x < 0x10; x++)
    printf (" %2X", x);
  puts ("\n--------------------------------------------------");
  for (x = 0; x < 4; x++) {
    printf ("%X ", x);
    for (y = 0; y < 0x10; y++) {
      Loc = (x << 4) + y;
      Data = ReadCMOS (Loc);
      printf (" %02X", Data);
    }
    printf ("\n");
  }
  WriteCMOS (0x1B, ReadCMOS (0x1B) + 1);
  NewCMOSChecksum ();
  printf ("\nNew value at location 1B = %02X\n", ReadCMOS (0x1B));
}
