/* RECTEST.C - Copyright (c) 1994, Signal Data, Inc.
 *
 *             Eric Bradway
 *             CompuServe: 73317,3601
 *             Voice: (615) 265-7076
 *             Fax  : (615) 756-8789
 *
 *    Intercepts the keyboard interrupt and displays printable typed
 *    keystrokes to a mono monitor (setup as a secondary display). Also
 *    displays some simple status info on the InDos flag and InBios flag.
 *
 *    Compile as follows:
 *
 *        CL /AS /Gs rectest.c
 */

/* Currently does not work unless Int 13 (BIOS Disk Services) is left alone
*/



#include <bios.h>
#include <dos.h>
#include <stdlib.h>
#include <process.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>


#define USHORT unsigned short
#define FALSE 0
#define TRUE 1

void  (_interrupt _far *gpfOld_int16)();
void  (_interrupt _far *gpfOld_int13)();
void  (_interrupt _far *gpfOld_int08)();
void  (_interrupt _far *gpfOld_int09)();


USHORT gusFile_handle = 0;

char _far * gpfIn_dos_flag = NULL;
char  gfIn_bios_flag = 0;

USHORT gausStore_keys[256];
USHORT gusNext_key = 0;


static char gfAlready_here = FALSE;

USHORT gusPos = 160;

char gachXlate_scan[] =
{
  ' ',
  ' ',
  '1',
  '2',
  '3',
  '4',
  '5',
  '6',
  '7',
  '8',
  '9',
  '0',
  '-',
  '=',
  ' ',
  ' ',
  'Q',
  'W',
  'E',
  'R',
  'T',
  'Y',
  'U',
  'I',
  'O',
  'P',
  '[',
  ']',
  ' ',
  ' ',
  'A',
  'S',
  'D',
  'F',
  'G',
  'H',
  'J',
  'K',
  'L',
  ';',

  '\'',

  '`',
  ' ',
  '\\',
  'Z',
  'X',
  'C',
  'V',
  'B',
  'N',
  'M',
  ',',
  '.',
  '/',
  ' ',
  '*', // ALT
  ' ', // Space
  ' ', // Caps
  ' ', // F1
  ' ', // F2
  ' ', // F3
  ' ', // F4
  ' ', // F5
  ' ', // F6
  ' ', // F7
  ' ', // F8
  ' ', // F9
  ' ', // F10
  ' ', // NumLock
  ' ', // ScrollLock
  ' ', // Home
  ' ', // UpArrow
  ' ', // PgUp
  '-', // Grey -
  ' ', // Left Arrow
  '5', // Keypad 5
  ' ', // Right Arrow
  ' ', // PgDn
  ' ', // Ins
  ' ', // Del
  ' ', // SysRq
  '\\', // 
  ' ', // F11
  ' ', // F12
  ' ', // PA1
  ' ', // F13
  ' ', // F14
  ' ', // F15
  ' ', // F16
  ' ', // F17
  ' ', // F18
  ' ', // F19
  ' ', // F20
  ' ', // F21
  ' ', // F22
  ' ', // F23
  ' ', // F24
  '-',
  ' ', // EraseEOF
  ' ' // Copy/Play
};



  /*  MonoPutc
   *  ------------------------------------------------------
   *  DESCRIPTION:
   *    Puts a single char onto the mono screen
   *  
   *  PARAMETERS:
   *
   *  
   *  RETURNS:
   *
   *  Zero      No Error
   *  Non-Zero  Error Return
   *
   *  GLOBALS AFFECTED:
   *
   *  
   */
void MonoPutc(char tchCharacter, USHORT tusX, USHORT tusY)
{
  char far *video_memory = 0xb0000000;

  *(video_memory + tusX * 2 + tusY * 160) = tchCharacter;
}



  /*  BuffToMono
   *  ------------------------------------------------------
   *  DESCRIPTION:
   *   Prints a buffer of characters to the mono monitor
   *  
   *  PARAMETERS:
   *    char * tpachBuffer
   *    short tsSize
   *  
   *  RETURNS:
   *
   *  Zero      No Error
   *  Non-Zero  Error Return
   *
   *  GLOBALS AFFECTED:
   *
   *  
   */
void StringToMono(char * tpachBuffer, USHORT tusLine)
{
  USHORT tusPosition = 0;

  do
    {
      MonoPutc(*(tpachBuffer), tusPosition, tusLine);
      tpachBuffer++;
      tusPosition++;
    }
  while (*(tpachBuffer));
}



  /*  Int09Main
   *  ------------------------------------------------------
   *  DESCRIPTION:
   *    This function traps interupt 09 (Keyboard Hardware Interrupt) and
   *    displays the keystroke on the second monitor
   *  
   *  PARAMETERS:
   *
   *  
   *  RETURNS:
   *
   *  Zero      No Error
   *  Non-Zero  Error Return
   *
   *  GLOBALS AFFECTED:
   *
   *  
   */
void _interrupt _far Int09Main(unsigned _ex, unsigned _ds,
                               unsigned _di, unsigned _si,
                               unsigned _bp, unsigned _sp,
                               unsigned _bx, unsigned _dx,
                               unsigned _cx, unsigned _ax,
                               unsigned _ip, unsigned _cs,
                               unsigned flags)

{
  unsigned char tchKey = 0;
  char tachBuffer[20];

  tchKey = inp(0x60);


  if (tchKey < 128)
    {
      gausStore_keys[gusNext_key] = tchKey;

      gusNext_key++;

      MonoPutc(gachXlate_scan[tchKey], gusPos % 80, gusPos / 80);

      gusPos++;
    }

  _chain_intr(gpfOld_int09);
  
}



  /*  Int13Main
   *  ------------------------------------------------------
   *  DESCRIPTION:
   *    This function traps interupt 13 (BIOS Disk Services) and
   *    keeps us from interrupting important, time-critical disk
   *    functions
   *  
   *  PARAMETERS:
   *
   *  
   *  RETURNS:
   *
   *  Zero      No Error
   *  Non-Zero  Error Return
   *
   *  GLOBALS AFFECTED:
   *
   *  
   */
void _interrupt _far Int13Main(unsigned _ex, unsigned _ds,
                               unsigned _di, unsigned _si,
                               unsigned _bp, unsigned _sp,
                               unsigned _bx, unsigned _dx,
                               unsigned _cx, unsigned _ax,
                               unsigned _ip, unsigned _cs,
                               unsigned flags)

{
  gfIn_bios_flag++;

  /* Now, chain to old interrupt
  */
  (*gpfOld_int13)();

  gfIn_bios_flag--;
}


  /*  Int08Main
   *  ------------------------------------------------------
   *  DESCRIPTION:
   *    This function traps interupt 08 (TIMER) and allows us
   *    to do all the groovy stuff that we couldn't do in the
   *    other interrupts
   *  
   *  PARAMETERS:
   *
   *  
   *  RETURNS:
   *
   *  Zero      No Error
   *  Non-Zero  Error Return
   *
   *  GLOBALS AFFECTED:
   *
   *  
   */
void _interrupt _far Int08Main(unsigned _ex, unsigned _ds,
                               unsigned _di, unsigned _si,
                               unsigned _bp, unsigned _sp,
                               unsigned _bx, unsigned _dx,
                               unsigned _cx, unsigned _ax,
                               unsigned _ip, unsigned _cs,
                               unsigned flags)

{
  USHORT tusLoop;
  USHORT tusBytes_written;

  if (gfAlready_here)
    _chain_intr(gpfOld_int08);


  gfAlready_here = TRUE;

  if (*gpfIn_dos_flag)
    {
      MonoPutc('Y', 8, 0);
      MonoPutc(' ', 9, 0);
    }
  else
    {
      MonoPutc(' ', 8, 0);
      MonoPutc('N', 9, 0);
    }

  if (gfIn_bios_flag)
    MonoPutc('Y', 20, 0);
  else
    MonoPutc('N', 20, 0);

  gfAlready_here = FALSE;

  _chain_intr(gpfOld_int08);
}




  /*  GetInDosFlag
   *  ------------------------------------------------------
   *  DESCRIPTION:
   *
   *  
   *  PARAMETERS:
   *
   *  
   *  RETURNS:
   *
   *  Zero      No Error
   *  Non-Zero  Error Return
   *
   *  GLOBALS AFFECTED:
   *
   *  
   */
void GetInDosFlag(char _far ** ppcFlag )
{
  union REGS regs;
  struct SREGS sregs;
  char _far * tpchFlag = NULL;

  regs.h.ah = 0x34;

  int86x(0x21, &regs, &regs, &sregs);

  FP_OFF(*ppcFlag) = regs.x.bx;
  FP_SEG(*ppcFlag) = sregs.es;

}



  /*  main
   *  ------------------------------------------------------
   *  DESCRIPTION:
   *    this sets up the TSR in memory
   *  
   *  PARAMETERS:
   *
   *  
   *  RETURNS:
   *
   *  Zero      No Error
   *  Non-Zero  Error Return
   *
   *  GLOBALS AFFECTED:
   *
   *  
   */
int cdecl main(int argc, char ** argv)
{
  int iCode_size = 0;
  USHORT tusError = 0;
  char tachBuffer[50];
  USHORT tusBytes_written = 0;

  StringToMono("IN_DOS:    In BIOS:", 0);

  StringToMono("BUFFER:", 1);

  GetInDosFlag(&gpfIn_dos_flag);
               
  printf("In DOS Flag: %04X:%04X\n", FP_SEG(gpfIn_dos_flag), FP_OFF(gpfIn_dos_flag));

  gpfOld_int13 = _dos_getvect(0x13);
  gpfOld_int09 = _dos_getvect(0x09);
  gpfOld_int08 = _dos_getvect(0x08);

  /* Disable all interrupts temporarily
  */
  _disable();

  /* Set the INT 13H vector
   * COMMENT OUT THIS NEXT LINE AND EVERYTHING WORKS - BE SURE TO COMMENT
   * OUT THE CORRESPONDING INTERRUPT RESET BELOW!!!
   */
  _dos_setvect(0x13, Int13Main);


  /* Set the INT 08H vector
  */
  _dos_setvect(0x08, Int08Main);


  /* Set the INT 09H vector
  */
  _dos_setvect(0x09, Int09Main);

  /* Enable all interrupts
  */
  _enable();


  /* Shell to DOS
  */
  fprintf(stdout, "Shelling to DOS\n");

  system("command.com");


  fprintf(stderr, "\nResetting...\n");


  /* Disable all interrupts temporarily
  */
  _disable();

  /* Reset all interrupts
  */
  _dos_setvect(0x09, gpfOld_int09);

  _dos_setvect(0x08, gpfOld_int08);


  /* Comment out this next line too!!!
  */
  _dos_setvect(0x13, gpfOld_int13);



  /* Enable all interrupts
  */
  _enable();

  return(-1);
}

