/* Driver for routine SHOOT */
/* Solves for eigenvalues of spheroidal harmonics. Both
prolate and oblate case are handled simultaneously, leading
to six first-order equations. Unknown to shoot, it is
actually two independent sets of three coupled equations,
one set with c^2 positive and the other with c^2 negative. */

#include <stdio.h>
#include <math.h>
#include "nr.h"

#define NVAR 6
#define N2 2
#define DELTA 1.0e-3
#define EPS 1.0e-6
#define DX 1.0e-4

float c2,factr;
int m,n;

void load(x1,v,y)
float x1,v[],y[];
{
	y[3]=v[1];
	y[2] = -(y[3]-c2)*factr/2.0/(m+1.0);
	y[1]=factr+y[2]*DX;
	y[6]=v[2];
	y[5] = -(y[6]+c2)*factr/2.0/(m+1.0);
	y[4]=factr+y[5]*DX;
}

void score(x2,y,f)
float x2,y[],f[];
{
	if ((n-m) % 2 == 0) {
		f[1]=y[2];
		f[2]=y[5];
	} else {
		f[1]=y[1];
		f[2]=y[4];
	}
}

void derivs(x,y,dydx)
float x,y[],dydx[];
{
	dydx[1]=y[2];
	dydx[3]=0.0;
	dydx[2]=(2.0*x*(m+1.0)*y[2]-(y[3]-c2*x*x)*y[1])/(1.0-x*x);
	dydx[4]=y[5];
	dydx[6]=0.0;
	dydx[5]=(2.0*x*(m+1.0)*y[5]-(y[6]+c2*x*x)*y[4])/(1.0-x*x);
}

main()
{
	int i;
	float h1,hmin,q1,x1,x2;
	float delv[3],v[3],dv[7],f[7];

	do {
		printf("Input M,N,C-Squared:  ");
		scanf("%d %d %f",&m,&n,&c2);
	} while (n < m || m < 0);
	factr=1.0;
	if (m) {
		q1=n;
		for (i=1;i<=m;i++) {
			factr *= (-0.5*(n+i)*(q1/i));
			q1 -= 1.0;
		}
	}
	v[1]=n*(n+1)-m*(m+1)+c2/2.0;
	v[2]=n*(n+1)-m*(m+1)-c2/2.0;
	delv[1]=DELTA*v[1];
	delv[2]=delv[1];
	h1=0.1;
	hmin=0.0;
	x1 = -1.0+DX;
	x2=0.0;
	printf("\n%17s %24s \n","Prolate","Oblate");
	printf("%11s %14s %10s %14s\n",
		"Mu(m,n)","Error Est.","Mu(m,n)","Error Est.");
	do {
		shoot(NVAR,v,delv,N2,x1,x2,EPS,h1,hmin,f,dv);
		printf("%12.6f %12.6f %12.6f %12.6f\n",v[1],dv[1],v[2],dv[2]);
	} while (fabs(dv[1]) > fabs(EPS*v[1]) || fabs(dv[2]) > fabs(EPS*v[2]));
}
