/* Driver for routine BNLDEV */

#include <stdio.h>
#include "nr.h"

#define N 20
#define NPTS 2000
#define ISCAL 200
#define NN 100
#define LLEN 50

main()
{
	char txt[LLEN+1];
	int i,j,k,idum=(-133),klim,dist[N+1];
	float pp,xm,dd;

	for (;;) {
		for (j=0;j<=N;j++) dist[j]=0;
		do {
			printf("Mean of distribution (0.0 to %d.0)",N);
			printf(" - Negative to end:\n");
			scanf("%f",&xm);
		} while (xm > 20.0);
		if (xm < 0.0) break;
		pp=xm/NN;
		for (i=1;i<=NPTS;i++) {
			j=bnldev(pp,NN,&idum);
			if (j >= 0 && j <= N) ++dist[j];
		}
		printf("Binomial-distributed deviate, mean %5.2f of %6d points\n",
			xm,NPTS);
		printf("%4s %8s %10s\n","x","p(x)","graph:");
		for (j=0;j<N;j++) {
			for (k=0;k<=LLEN;k++) txt[k]=' ';
			dd=(float) dist[j]/NPTS;
			klim=ISCAL*dd+1;
			if (klim > LLEN) klim=LLEN;
			for (k=1;k<=klim;k++) txt[k]='*';
			txt[LLEN]='\0';
			printf("%4d %9.4f   %s\n",j,dd,txt);
		}
	}
}
