// =========================================================
// TEST.CPP
//
// Test program for Chicago-style property sheet dialog box
//
// Author:  Steve Saxon (Compuserve: 100321,2355)
// Written: 24th June 1994
// =========================================================

#include <owl\owlpch.h>
#pragma hdrstop

#include "propdlg.h"
#include "fontdlg.h"
#include "wizard.h"

#include "test.rh"
#include "fontdlg.rh"
#include "wizard.rh"

// control definitions for address dialog
#include <owl\edit.h>
#include <owl\checkbox.h>

#define SHOWPRINTERFONTS		1		// 1=display printer fonts, 0=display screen fonts

// =========================================================
// TestApp
//
// test application object
// =========================================================
class TestApp : public TApplication
{
public:
	TestApp ();
	virtual ~TestApp ();

	virtual void InitMainWindow();
};

// =========================================================
// TMainWindow
//
// main window object
// =========================================================
class TMainWindow : public TFrameWindow
{

public:
	TMainWindow (LPCSTR lpszTitle);

	void		GetWindowClass (WNDCLASS& wc);
	LPSTR		GetClassName ();

	void		TestDialog ();
	void		TestDialog2 ();
	void		FormatDialog ();
	void 		AddressDialog ();
	void		WizardDialog ();

	void 		EvSysColorChange ();

	DECLARE_RESPONSE_TABLE (TMainWindow);
};

// =========================================================
// TFormatDialog
//
// property dialog for format page
// =========================================================
class TFormatDialog : public TPropertyDialog
{

public:
	TFormatDialog (TWindow *pParent, TResId resID, Tab::Style style);

	void 	CmApplyNow ();

	DECLARE_RESPONSE_TABLE (TFormatDialog);
};

// =========================================================
// TAddressDialog, TAddressPage
//
// overriden property dialogs
// =========================================================
class TAddressPage : public TPropertyPage
{
	int				nLastSaved;

public:
	TAddressPage (TResId resID, TModule *module = 0);

	BOOL			SaveData ();
	void			LoadData (int nTab);
};

class TAddressDialog : public TPropertyDialog
{
	TAddressPage	*Page;
	TTransferArray	transfer[26];

public:
	TAddressDialog (TWindow *pParent, TResId resID, Tab::Style style);

	virtual void	AfterSelected (int nTab);

	TTransferArray&	GetTransferArray (int nTab)	{ return transfer[nTab]; }
};

// =========================================================
// TMyPropertyPage
//
// overriden property page
// =========================================================
class TMyPropertyPage : public TPropertyPage
{

public:
	TMyPropertyPage (TResId res);

	void	SetupWindow ();
	void	CmCheckClicked ();
	void	CmPrevious ();
	void	CmNext ();
	void	CmTestForEach ();

	DECLARE_RESPONSE_TABLE (TMyPropertyPage);
};

// =========================================================

TestApp::TestApp () : TApplication("Test System")
{
	EnableCtl3d (TRUE);
}

TestApp::~TestApp ()
{
}

void TestApp::InitMainWindow ()
{
	SetMainWindow (new TMainWindow (GetName ()));
}

// =========================================================

DEFINE_RESPONSE_TABLE1(TMainWindow, TFrameWindow)
  EV_WM_SYSCOLORCHANGE,
  EV_COMMAND(CM_TEST, TestDialog),
  EV_COMMAND(CM_TEST2, TestDialog2),
  EV_COMMAND(CM_FORMAT, FormatDialog),
  EV_COMMAND(CM_ADDRESS, AddressDialog),
  EV_COMMAND(CM_WIZARD, WizardDialog),
END_RESPONSE_TABLE;

TMainWindow::TMainWindow (LPCSTR lpszTitle)
	: TFrameWindow (NULL, lpszTitle)
{
}

void TMainWindow::GetWindowClass (WNDCLASS& wc)
{
	TFrameWindow::GetWindowClass (wc);

	wc.lpszMenuName = MAKEINTRESOURCE (MENU_1);
}

LPSTR TMainWindow::GetClassName ()
{
	return "Test:Main";
}

void TMainWindow::EvSysColorChange ()
{
	// get TPropertyDialog to update the tab and dialog colors
	TPropertyDialog::TabColorChange (GetApplication ());
}

void TMainWindow::TestDialog ()
{
	TPropertyDialog	Property (this, IDD_TEST, Tab::SingleHeight | Tab::Stacked | Tab::CreateOnDemand | Tab::ButtonsOnRight);

	Property.Add ("&First page", 		new TMyPropertyPage (CHILD_1));
	Property.Add ("&Another page",		new TMyPropertyPage (CHILD_2), FALSE);
	Property.Add ("&Yet another page", 	new TMyPropertyPage (CHILD_3));
	Property.Add ("&Even more pages", 	new TMyPropertyPage (CHILD_4));
	Property.Add ("New stacked page",	new TMyPropertyPage (CHILD_5));
	Property.Add ("Fina&l page",		new TMyPropertyPage (CHILD_5));

	Property.Execute ();
}

void TMainWindow::TestDialog2 ()
{
	TPropertyDialog	Property (this, IDD_TEST, Tab::DoubleHeight | Tab::Collapsing | Tab::Justified | Tab::ButtonsOnRight);

	Property.Add ("First\r\npage", 				new TMyPropertyPage (CHILD_1));
	Property.Add ("Second (and wide)\r\npage",	new TMyPropertyPage (CHILD_2), FALSE);
	Property.Add ("Third\r\npage", 				new TMyPropertyPage (CHILD_3));
	Property.Add ("Fourth\r\npage (the widest)",new TMyPropertyPage (CHILD_4));
	Property.Add ("Fifth-and-final", 			new TMyPropertyPage (CHILD_5));

	Property.Execute ();
}

void TMainWindow::FormatDialog ()
{
	TFormatDialog		Format (this, IDD_FORMATDLG, Tab::SingleHeight);
#if SHOWPRINTERFONTS
	TPrinter			printer;
	TPrinterFontData	fontdata (printer);
#else
	TFontData	fontdata;
#endif

	fontdata.Flags	|= CF_INITTOLOGFONTSTRUCT;
	fontdata.PointSize = 240;

	lstrcpy (fontdata.LogFont.lfFaceName, "Arial");
	fontdata.LogFont.lfWeight		= FW_BOLD;
	fontdata.LogFont.lfUnderline	= TRUE;

	fontdata.Flags	|= CF_LIMITSIZE;
	fontdata.SizeMin	= 12;
	fontdata.SizeMax	= 36;

	Format.Add ("Font", 		new TFontPropertyPage (IDD_FONTDLG, fontdata));
	Format.Add ("Another page",	new TMyPropertyPage (CHILD_2), TRUE);
	Format.Add ("Font #2", 		new TFontPropertyPage (IDD_FONTDLG, fontdata));

	Format.Execute ();
}

void TMainWindow::AddressDialog ()
{
	TAddressDialog	Address (this, IDD_ADDRESSTEST,
			Tab::SingleHeight 	|
			Tab::Stacked 		|
			Tab::FixedWidth 	|
			Tab::AllowDupPages 	|
			Tab::UseSmallFont);

	Address.SetFixedTabWidth (30);

	Address.Execute ();
}

void TMainWindow::WizardDialog ()
{
	TWizardDialog	Wizard (this, IDD_WIZARDDLG);

	Wizard.Add ("test #1", new TWizardPage (WIZARDTEST, IBM_WIZARDTEST));
	Wizard.Add ("test #2", new TMyPropertyPage (CHILD_1));
	Wizard.Add ("test #3", new TMyPropertyPage (CHILD_2), FALSE);
	Wizard.Add ("test #4", new TMyPropertyPage (CHILD_3));
	Wizard.Add ("test #5", new TMyPropertyPage (CHILD_4));
	Wizard.Add ("test #6", new TMyPropertyPage (CHILD_5));
	Wizard.Add ("test #7", new TMyPropertyPage (CHILD_5));

	Wizard.Execute ();
}

// =========================================================
// TFormatDialog
//
// property dialog for format page
// =========================================================
DEFINE_RESPONSE_TABLE1 (TFormatDialog, TPropertyDialog)
	EV_BN_CLICKED (IDC_APPLYNOW, CmApplyNow),
END_RESPONSE_TABLE;

TFormatDialog::TFormatDialog (TWindow *pParent, TResId resID, Tab::Style style)
	: TPropertyDialog (pParent, resID, style)
{
}

void TFormatDialog::CmApplyNow ()
{
	MessageBox ("\'Apply Now\' button pressed", "Format", MB_OK | MB_ICONINFORMATION);
}

// =========================================================
// TAddressDialog, TAddressPage
//
// overriden property dialogs for address book example
// =========================================================
TAddressDialog::TAddressDialog (TWindow *pParent, TResId resID, Tab::Style style)
	: 	TPropertyDialog (pParent, resID, style)
{
	Page = new TAddressPage (IDD_ADDRESS);

	char	szTitle[2];

	szTitle[1] = '\0';

	for (char cLetter = 'A'; cLetter <= 'Z'; cLetter++)
	{
		szTitle[0] = cLetter;
		Add (szTitle, Page);
	}
}

void TAddressDialog::AfterSelected (int nTab)
{
	Page->SaveData ();	// ask page to save its current data

	Page->LoadData (nTab);
}

TAddressPage::TAddressPage (TResId resID, TModule *module)
	: TPropertyPage (resID, module)
{
	new TEdit (this, IDC_EDIT1);
	new TEdit (this, IDC_EDIT2);
	new TCheckBox (this, IDC_CHECKBOX1);
	
	nLastSaved = -1;
}

BOOL TAddressPage::SaveData ()
{
	if (nLastSaved == -1)
	{
		return TRUE;
	}

	// save away the fields here
	dynamic_cast<TAddressDialog &> (GetPropertyDialog ()).GetTransferArray (nLastSaved).TransferData (this, tdGetData);

	nLastSaved = -1;

	return TRUE;
}

void TAddressPage::LoadData (int nTab)
{
	SaveData ();

	nLastSaved = nTab;

	// load the new fields here
	dynamic_cast<TAddressDialog &> (GetPropertyDialog ()).GetTransferArray (nTab).TransferData (this, tdSetData);
}

// =========================================================

DEFINE_RESPONSE_TABLE1(TMyPropertyPage, TPropertyPage)
  EV_BN_CLICKED(IDC_CHECKBOX1, CmCheckClicked),
  EV_BN_CLICKED(IDC_PREVIOUS, CmPrevious),
  EV_BN_CLICKED(IDC_NEXT, CmNext),
  EV_BN_CLICKED(IDC_TEST, CmTestForEach),
END_RESPONSE_TABLE;

TMyPropertyPage::TMyPropertyPage (TResId res)
	: TPropertyPage (res)
{
}

void TMyPropertyPage::SetupWindow ()
{
	TPropertyPage::SetupWindow ();

	CheckDlgButton (IDC_CHECKBOX1, IsTabEnabled (1));
}

void TMyPropertyPage::CmCheckClicked ()
{
	EnableTab (1, IsDlgButtonChecked (IDC_CHECKBOX1));
}

void TMyPropertyPage::CmPrevious ()
{
	SelectPrevious ();
}

void TMyPropertyPage::CmNext ()
{
	SelectNext ();
}

// =========================================================

void SetPageColour (TPropertyPage *pPage, void *param)
{
	pPage->SetBkgndColor ((COLORREF) param);

	if (pPage->IsWindowVisible ())
	{
		pPage->Invalidate ();
	}
}

void TMyPropertyPage::CmTestForEach ()
{
	GetPropertyDialog ().ForEachPage (SetPageColour, (void *) RGB (0, 255, 0));
}

// =========================================================

int OwlMain (int , char* [])
{
	TestApp		App;
	int			result;

	result = App.Run();

	return result;
}