#ifndef __PROPERTY_DIALOGS
#define __PROPERTY_DIALOGS

#include <owl\owlpch.h>
#pragma hdrstop

#include <classlib\arrays.h>

#ifndef USETRANSFERARRAYS
  #define USETRANSFERARRAYS	FALSE
#endif

#define DEFTABWIDTH			64
#define DEFWIDEMARGIN		6

#if USETRANSFERARRAYS
  #include "tfarry.h"
#endif

#if defined (BUILDPROPDLGDLL)
  #define PROPDLGEXPORT	__export
#elif defined (PROPDLGDLL)
  #define PROPDLGEXPORT	__import
#else
  #define PROPDLGEXPORT
#endif

class PROPDLGEXPORT TPropertyTab;
class PROPDLGEXPORT TPropertyPage;
class PROPDLGEXPORT TPropertyDialog;

typedef void (*TPageActionFunc)(TPropertyPage* page, void* param);
typedef BOOL (*TPageCondFunc)(TPropertyPage* page, void* param);

typedef void (TPropertyDialog::*TPageActionMemFunc)(TPropertyPage* page, void* param);
typedef BOOL (TPropertyDialog::*TPageCondMemFunc)(TPropertyPage* page, void* param);

void	UseSmallFont (HWND HWindow);

class PROPDLGEXPORT Tab
{
public:
	enum Style {                
			SingleHeight 	= 0x0000,
			VariableWidth 	= 0x0000,
			DoubleHeight	= 0x0001,
			FixedWidth 		= 0x0002,
			ColorActive		= 0x0004,
			Collapsing		= 0x0008,
			Justified		= 0x0010,
			Stacked			= 0x0020,
			AllowDupPages	= 0x0040,
			CreateOnDemand	= 0x0080,
			WideMargins		= 0x0100,
			AutoTabResize	= 0x0200,
			ButtonsOnRight	= 0x0400,
			UseSmallFont	= 0x0800,
			SaveOnClosePage = 0x1000,
			NoMDIClose      = 0x2000,
			WizardFrame		= 0x4000
			};
};

class PROPDLGEXPORT TPropertyPage : public TDialog
{
	friend	TPropertyDialog;	// allows access to pdlgParent

	int 			nThisTab;

protected:
	TPropertyDialog	*pdlgParent;

	void    		CmOk ();      	// IDOK
	void    		CmCancel ();    // IDCANCEL
	void 			EvSysCommand (UINT cmdType, TPoint& pt);

	BOOL 			CheckHotKey (TDialog *dlg = NULL);

public:
	TPropertyPage (TResId resID, TModule *module = 0);
	TPropertyPage (TPropertyDialog *parent, TResId resID, TModule *module = 0);
	~TPropertyPage ();

	int             MessageBox (const char far* text,
								const char far* caption = 0,
								UINT            type = MB_OK);

	TPropertyDialog& GetPropertyDialog ()	{ return *pdlgParent; }
	TWindow			*GetParentWindow ();
	int				ThisTab ()				{ return nThisTab; }

	virtual void 	SelectTab (int nTab = -1);
	virtual void 	SelectNext ();
	virtual void 	SelectPrevious ();

	void			EnableTab (int nTab = -1, BOOL bEnable = TRUE);
	BOOL			IsTabEnabled (int nTab = -1);

	// overridable functions
	virtual void	AfterSelected ()		{  }
	virtual BOOL	CanPageClose ()			{ return TRUE; }
	virtual void	AfterCantClose ()		{ SelectTab (); }

	virtual BOOL	SaveData ();

#if USETRANSFERARRAYS
	DECLARE_USETRANSFERARRAY(TPropertyPage, TDialog);
#endif

	DECLARE_RESPONSE_TABLE (TPropertyPage);
};

class PROPDLGEXPORT TPropertyDialog : public TDialog
{

protected:
	TPropertyTab	*pTabs;
	Tab::Style 		styleTabs;

	int				DoExecute ();

	void			EvDestroy ();
	BOOL    		EvInitDialog(HWND hWndFocus);
	void 			SizeTabWnd (TRect& client);
	void 			EvSysCommand (UINT cmdType, TPoint& pt);

	virtual void	AdjustMargin (TRect& rc);

public:
	TPropertyDialog (TWindow *pParent, TResId resID, Tab::Style style = Tab::SingleHeight | Tab::VariableWidth, TModule *module = 0);
	~TPropertyDialog ();

	static void		SetHookInstance (HINSTANCE hInstance);
	static void 	TabColorChange (TApplication *application = NULL);

	void			SetupWindow ();
	void 			Destroy (int retValue = 0);
	void			EvSize (UINT, TSize& size);

	// message routing
	BOOL 			Find (TEventInfo&, TEqualOperator = 0);
	LRESULT 		Dispatch(TEventInfo&, WPARAM, LPARAM = 0);

	// get reference to a particular page
	TPropertyPage&	GetPageRef (int nTab = -1);
	int				GetEntryCount ();

	// function to add a new tab
	virtual void	Add (LPCSTR lpszTab, TPropertyPage *pPage, BOOL bEnabled = TRUE);

	virtual void	CmOk ();      	// IDOK
	virtual void	CmCancel ();    // IDCANCEL
	virtual void	CloseAction (int retValue);

	virtual void 	SelectTab (int nTab);
	virtual void 	SelectNext ();
	virtual void 	SelectPrevious ();
	virtual void	AfterSelected (int nTab)	{ /* you can override this -- */ }

	// global properties for every tab
	void 			SetActiveColor (TColor color = TColor::Black);
	void 			SetFixedTabWidth (int nWidth = DEFTABWIDTH);
	void 			SetWideMarginWidth (int nWidth = DEFWIDEMARGIN);

	// page iterators that take function pointers
	TPropertyPage*	FirstPageThat (TPageCondFunc test, void* paramList = 0);
	void            ForEachPage (TPageActionFunc action, void* paramList = 0);

	// page-iterators that take pointers to member functions
	TPropertyPage*	FirstPageThat (TPageCondMemFunc test, void* paramList = 0);
	void            ForEachPage (TPageActionMemFunc action, void* paramList = 0);

	// similar to ForEach - sends Windows message to each page
	LRESULT 		SendMsgToEachPage (UINT msg, WPARAM wParam = 0, LPARAM lParam = 0);

//	DECLARE_RESPONSE_TABLE(TPropertyDialog);
private:
	static TResponseTableEntry<TPropertyDialog> __RTFAR	__entries[];
	typedef TResponseTableEntry<TPropertyDialog>::PMF   TMyPMF;
	typedef TPropertyDialog								TMyClass;
};

#endif
