// =========================================================
// WIZARD.CPP
//
// Chicago-style wizard property dialog classes for OWL 2
//
// Author:  Steve Saxon (Compuserve: 100321,2355)
// Written: 15th October 1994
// =========================================================

#include <owl\owlpch.h>
#pragma hdrstop

#include "wizard.h"
#include "proptab.h"
#include "wizard.rh"

// =========================================================
// TWizardDialog
//
// base class for wizard dialogs (page holder)
// =========================================================

DEFINE_RESPONSE_TABLE1(TWizardDialog, TPropertyDialog)
	EV_BN_CLICKED (IDC_WIZ_BACK, SelectPrevious),
	EV_BN_CLICKED (IDC_WIZ_NEXT, SelectNext),
END_RESPONSE_TABLE;

TWizardDialog::TWizardDialog (TWindow *pParent, TResId resID, Tab::Style style, TModule *module)
	:	TPropertyDialog (pParent, resID, style | Tab::WizardFrame, module)
{
	bEnableNext = bEnablePrev = TRUE;
}

TWizardDialog::~TWizardDialog ()
{
}

void TWizardDialog::SetupWindow ()
{
	TPropertyDialog::SetupWindow ();
}

void TWizardDialog::SelectNext ()
{
	// only allow next to be selected if we
	// aren't already on the last
	if (bEnableNext)
	{
		TPropertyDialog::SelectNext ();
	}
}

void TWizardDialog::SelectPrevious ()
{
	// only allow previous to be selected if we
	// aren't already on the first
	if (bEnablePrev)
	{
		TPropertyDialog::SelectPrevious ();
	}
}

void TWizardDialog::AfterSelected (int nTab)
{
	// enable navigation buttons as necessary...

	// determine if this is the first enabled button
	BOOL	bFirstTab = TRUE;

	for (int n = 0; n < nTab; n++)
	{
		if (GetPageRef (n).IsTabEnabled ())
		{
			bFirstTab = FALSE;
			break;
		}

	}

	HWND hwndBackBtn	= GetDlgItem (IDC_WIZ_BACK);
	HWND hwndNextBtn 	= GetDlgItem (IDC_WIZ_NEXT);
	HWND hwndOKBtn 		= GetDlgItem (IDOK);

	if (hwndBackBtn)
	{
		bEnablePrev = !bFirstTab;
		
		::EnableWindow (hwndBackBtn, bEnablePrev);
	}

	// determine if this is the last enabled button
	BOOL	bLastTab = TRUE;

	while (++nTab < GetEntryCount ())
	{
		if (GetPageRef (nTab).IsTabEnabled ())
		{
			bLastTab = FALSE;
			break;
		}
	}

	if (hwndNextBtn)
	{
		if (!bLastTab)
		{
			SetDefaultId (IDC_WIZ_NEXT);
		}

		bEnableNext = !bLastTab;

		::EnableWindow (GetDlgItem (IDC_WIZ_NEXT), bEnableNext);
	}

	if (hwndOKBtn)
	{
		::EnableWindow (GetDlgItem (IDOK), bLastTab);
	}

	if (bLastTab && hwndOKBtn)
	{
		SetDefaultId (IDOK);
	}

	if (hwndNextBtn)
	{
		PostMessage (WM_NEXTDLGCTL, (WPARAM) GetDlgItem (GetDefaultId ()));
	}
	else
	{
		pTabs->SelectFirstControl ();
	}
}

// =========================================================
// TWizardPage
//
// base class for wizard pages
// =========================================================

TWizardPage::TWizardPage (TResId resID, int idBitmap, TBitmapControl::Style style, TModule *module)
	: TPropertyPage (resID, module)
{
	if (idBitmap)
	{
		bitmap = new TBitmapControl (this, idBitmap, style, module);
	}
	else
	{
		bitmap = NULL;
	}
}

TWizardPage::TWizardPage (TPropertyDialog *parent, TResId resID, int idBitmap, TBitmapControl::Style style, TModule *module)
	: TPropertyPage (parent, resID, module)
{
	if (idBitmap)
	{
		bitmap = new TBitmapControl (this, idBitmap, style, module);
	}
	else
	{
		bitmap = NULL;
	}
}

