#ifndef __FONT_PROPDLG
#define __FONT_PROPDLG

#include <owl\combobox.h>
#include <owl\static.h>
#include <owl\choosefo.h>
#include <owl\printer.h>
#include <owl\listbox.h>
#include "propdlg.h"

class TFontNameList;
class TColorList;
class TSampleStatic;

// ---------------------------------------------------
// private definitions
// ---------------------------------------------------
class TFontSpec
{
	int		nType;
	int		nFamily;
	LOGFONT	lf;

public:
	TFontSpec (int nType, const LOGFONT& lf, int nFamily);

	LPCSTR		GetName ()		{ return lf.lfFaceName; }
	int			GetType ()		{ return nType; }
	int			GetFamily ()	{ return nFamily; }
	LOGFONT&	GetLogFont ()	{ return lf; }

	BOOL	operator< (TFontSpec);
	BOOL	operator== (TFontSpec);
};

typedef TISArrayAsVector<TFontSpec>	TFontList;

// ---------------------------------------------------
// public definitions
// ---------------------------------------------------
class PROPDLGEXPORT TFontData : public TChooseFontDialog::TData
{
public:
	TFontData ();
};

class PROPDLGEXPORT TPrinterFontData : public TFontData
{
	TPrintDC		*pdc;
public:
	TPrinterFontData (TPrinter& printer);
	~TPrinterFontData ();
};

class PROPDLGEXPORT TFontPropertyPage : public TPropertyPage
{
	TFontData&		fontdata;
	TFontList		fontlist;
	TFont			*ptFontSample;

	TFontNameList	*pcbFontName;
	TComboBox		*pcbFontStyle;
	TComboBox		*pcbFontSize;
	TColorList		*pcbColor;
	TSampleStatic	*peditSample;
	BOOL			bUpdatePending;

	TIntArray		arrayBold;
	TIntArray		arrayItalic;
	int				nFontNameIndex;
	int				nFontPointSize10;

	void			FontSelected (TDC& dc, int nIndex);
	LRESULT			AfterSelection (WPARAM, LPARAM);
	void			EvAfterChange ()	{ if (!bUpdatePending) { PostMessage (WM_USER); bUpdatePending++; } }
	int				GetSelItem (TComboBox *ptList);

	void  			EvMeasureItem(UINT, MEASUREITEMSTRUCT far& measureInfo);

protected:
	virtual void	EvFontName ();
	virtual void	EvFontStyle ();
	virtual void	EvFontSize ();
	virtual void	EvColor ();

public:
	TFontPropertyPage (TResId resID, TFontData& fontdata, TModule *module = 0);
	~TFontPropertyPage ();

	virtual void	SetupWindow ();
	virtual BOOL	SaveData ();

	DECLARE_RESPONSE_TABLE (TFontPropertyPage);
};

#endif
