/****************************************************************************
 *                                                                          *
 *                             The WINDOW PRO                               *
 *                                                                          *
 *                           Seabreeze Software                             *
 *                                                                          *
 *               copyright (c) 1986, 1987 by Kenneth Stott                  *
 *                                                                          *
 ****************************************************************************

Filename: INITWDWS.C
Library : TCPOWER.LIB, MSCPOWER.LIB
Author  : Kenneth Stott
Date    : 11/07/87

Function Description:

Initializes various window pro structures and variables for an IBM-PC.

+-----------------------------------------------------------------------------+
|Modification Description                               | Initials |  Date    |
+-----------------------------------------------------------------------------+
|1. Checks for mouse and updates global variable        | KRS      | 12/26/87 |
|   'mouse_installed.'                                  |          |          |
------------------------ version 1.4 released ---------------------------------
|2. Added support for left/right/center justify on      | KRS      | 11/25/88 |
|   on tile names                                       |          |          |
|3. Merged globals.h into this source file              | KRS      | 11/25/88 |
|4. Sets mouse to software cursor style (if installed)  | KRS      | 11/25/88 |
+-----------------------------------------------------------------------------+
*/

/* Includes */
#include "portable.h"
#include "pro.h"
#include "kernel.h"
#include "xglobals.h"
#include "vidmodes.h"
#include "werrors.h"
#include "video.h"
#include "mouse.h"
#include "colors.h"

unsigned char *default_box,
	box0[13] = {(unsigned char) 0xC9, (unsigned char) 0xBB,
		(unsigned char) 0xBC, (unsigned char) 0xC8,
		(unsigned char) 0xCD, (unsigned char) 0xBA,
		' ', ' ', ' ', ' ', (unsigned char) 0xCD,
		(unsigned char) 0xCC, (unsigned char) 0xB9},
	box1[13] = {(unsigned char) 0xDA, (unsigned char) 0xBF,
		(unsigned char) 0xD9, (unsigned char) 0xC0,
		(unsigned char) 0xC4, (unsigned char) 0xB3,
		' ', ' ', ' ', ' ', (unsigned char) 0xC4,
		(unsigned char) 0xC3, (unsigned char) 0xB4},
	box2[13] = {(unsigned char) 0xC9, (unsigned char) 0xBB,
		(unsigned char) 0xBC, (unsigned char) 0xC8,
		(unsigned char) 0xCD, (unsigned char) 0xBA,
		' ', ' ', ' ', ' ', (unsigned char) 0xC4,
		(unsigned char) 0xC7, (unsigned char) 0xB6},
	box3[13] = {(unsigned char) 0xD6, (unsigned char) 0xB7,
		(unsigned char) 0xBD, (unsigned char) 0xD3,
		(unsigned char) 0xC4, (unsigned char) 0xBA,
		' ', ' ', ' ', ' ', (unsigned char) 0xC4,
		(unsigned char) 0xC7, (unsigned char) 0xB6},
	box4[13] = {(unsigned char) '',(unsigned char)'',
		(unsigned char)'',(unsigned char)'',(unsigned char)'',
		(unsigned char)'',' ',' ',' ',' ',(unsigned char)'',
		(unsigned char)'',(unsigned char)''};

int box[13], tab_expansion = 10, snowspeed = 150, mouse_installed = FALSE,
	horizontal_mouse_resolution = 640, vertical_mouse_resolution = 200;

unsigned int active_wdw = MAX_WINDOWS, first_wdw = MAX_WINDOWS,
	last_wdw = MAX_WINDOWS, physical_columns = 80, physical_rows = 25,
	frozen = FALSE, zoomed = FALSE, balance1 = 0, oldx, oldy;

wdw_rec far *wdw[MAX_WINDOWS + 1], zoomed_wdw;
tile_rec zoomed_tile;
blkrec  far *overlay = NULL;
screen_char far *primary_scr, far *alt_scr, far *curr_scr, far *screen_buffer;
unsigned char active_attr = 0x0F, inactive_attr = 0x17, active_tile_attr = 0x0A,
	inactive_tile_attr = 0x0C,
	error_flag = TRUE, vpage, method = 1, cursor_e = 1, cursor_b = 2,
	cursor_on = TRUE, scroll_bars_on = 3, thumbwheels_on = 3,
	ega_mlines = FALSE, snowfree = FALSE,
	ibm_fcolor_table[16] = {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15},
	ibm_bcolor_table[16] = {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15},
	sbu = 0x1E, sbd = 0x1F, sbr = 0x10, sbl = 0x11, oldb, olde,
	thumbwheels_area = '', thumbwheels_char = '';

char *ansi_fcolor_table[16] = {"0;1;30", "0;1;34", "0;1;32", "0;1;36", "0;1;31",
		"0;1;35", "0;1;36", "0;37", "0;4;30",
		"0;34", "0;32", "0;36", "0;31", "0;35", "0;1;33", "0;1;37"},
	*ansi_bcolor_table[16] = {"40", "44", "42", "46", "41", "45",
		"46", "47", "47", "5;44", "5;42", "5;46", "5;41",
		"5;45", "5;43", "5;47"},
	*position_cursor = "\033[%d;%dH",
	*change_color = "\033[%s;%sm",
	buf[1000],
	default_justify = 0,
	default_tile_justify = 1;

int wn_init()
{
	int count, scrmode;

	default_box = box0;

	/*
	 * Initialize the array of window handles to NULL, only window
	 * handles of NULL can be assigned.
	*/
	for (count = 0; count < (MAX_WINDOWS + 1); count ++)
		wdw[count] = NULL;

	/* get the current screen mode */
	scrmode = v_getmode();

	/* get the current video page */
	vpage = (unsigned char) v_getpage();

	/* remember the state of the cursor */
	v_cursor_report(&oldx, &oldy, &oldb, &olde);

	/*
	 * initialize our cursor to be the same as the cursor the
	 * user had set
	*/
	cursor_b = oldb;
	cursor_e = olde;

	/* set the screen buffer to indicate that we have nothing in it */
	screen_buffer = NULL;

	/*
	 * if were are not in one of the supported modes try and
	 * set mode to the cga 80 column color text mode --
	 * kind of dangerous if the card doesn't support that mode.
	*/
	if ((scrmode != co40) && (scrmode != co80) &&
		(scrmode != bw40) && (scrmode != bw80) &&
		(scrmode != mono)) {
		scrmode = co80;
		v_setmode(co80);
	}

	/* if cga mode 40 column set globals as follows */
	if ((scrmode == co40) || (scrmode == bw40)) {
		physical_columns = 40;
		physical_rows = 25;
		curr_scr = primary_scr = (screen_char far *) ( EGA_CGA_ADDRESS +
			vpage * SCR_SIZE);
	}

	/* otherwise if cga 80 column mode set globals as follows */
	if ((scrmode == co80) || (scrmode == bw80)) {
		physical_columns = 80;

		/*
		 * if we indicated -- before calling wn_init -- that
		 * we had more than 25 rows than use that figure in place
		 * of 25 rows
		*/
		if (ega_mlines) physical_rows = ega_mlines;
		else physical_rows = 25;
		curr_scr = primary_scr = (screen_char far *)
			(EGA_CGA_ADDRESS + vpage * SCR_SIZE);
	}

	/* or if a monochrome adapter set as follows */
	if (scrmode == mono) {
		physical_columns = 80;

/************************** THIS IS THE FIX !!!! **********************/
		if (ega_mlines) physical_rows = ega_mlines;
		else physical_rows = 25;
/**********************************************************************/

		curr_scr = primary_scr = (screen_char far *) MDA_ADDRESS;
	}

	/*
	 * alt_scr is a pointer to a screen buffer, where we
	 * build complicated screens -- and then flash them onto
	 * the physical screen
	*/
	alt_scr = k_malloc(SCR_SIZE);
	if (alt_scr == NULL) return(OUT_OF_MEMORY);

	/* screen_buffer holds the background for the windows */
	screen_buffer = k_malloc(SCR_SIZE);
	if (screen_buffer == NULL) return (OUT_OF_MEMORY);

	/*
	 * If under ANSI we have no method of reading the screen so we just set
	 * this equal to a BLACK on BLACK background.
	*/
	if (method == ANSI) {
		for (count = 0; count < (physical_columns * physical_rows);
			count++) {
			screen_buffer[count].character = 0x00;
			screen_buffer[count].attribute = white + (black << 4);
		}
	}

	/*
	 * execute this anytime you want to save the current screen as
	 * the background for the windows.
	*/
	if (method != ANSI) wn_savescr();

	/* make sure we initialize to a viewable color if in ANSI mode */
	if (method == ANSI) printf(change_color,ansi_fcolor_table[7],
		ansi_bcolor_table[0]);

	/* initialize mouse */
	mouse_installed = kb_ismouse();
	if(mouse_installed) kb_settextcursor(0,0x77FF,0x7700);

	return(OK);
}
