//=====================================================================
//
//  int86.cpp
//
//  call dos / bios 
//
//  Protected Mode version
//
//  Copyright (c) 1994, Kevin Morgan, All rights reserved.
//
//=====================================================================

#include <stdio.h>
#include <string.h>
#include <dos.h>

#include "dpmish.h"
#include "dosext.h"

class RealInt {
    public:
	unsigned char opcode;
	unsigned char intnr;
	unsigned char retf;
    RealInt(unsigned anOp, unsigned anInt, unsigned aRet) :
        opcode(anOp), intnr(anInt), retf(aRet) { }
};

//=====================================================================
//
//  int86x
//
//  handle int86 calls from protected mode
//=====================================================================
int int86x(int intNr, REGS far *inregs, REGS far *outregs, SREGS far *segregs)
{
	RealInt *code = new RealInt( 0xcd, intNr, 0xcb);    // int x; retf
    void far (far *newCode)(void);
    unsigned ExecuteSeg;
	if (Dpmi.createAlias(FP_SEG(code), ExecuteSeg)!=DPMI_OK) {
		return -1;
	}
    if (Dpmi.setAccessRights(ExecuteSeg, AccessRightsCode)!=DPMI_OK)
        return -1;

	FP_SEG(newCode) = ExecuteSeg;			// use alias effect
    FP_OFF(newCode) = FP_OFF( code );

	asm{
    	lds     si, segregs
        mov     ax, [si].(SREGS)es
        push ax
        mov     ax, [si].(SREGS)ds
        push ax

    	lds     si, inregs
    	mov     ax, [si].(REGS)x.ax
    	mov     bx, [si].(REGS)x.bx
    	mov     cx, [si].(REGS)x.cx
    	mov     dx, [si].(REGS)x.dx
    	mov     di, [si].(REGS)x.di
    	mov     si, [si].(REGS)x.si
    	pop     ds
    	pop     es

    	push    bp              /* just to be safe */
    }
        (*newCode)();
    asm {
    	pop     bp

        /* Set register structure with registers */
        push    ax
    	pushf
    	pushf
    	push    si
    	push    ds
    	push    es

    	lds     si, segregs
    	pop     ax; mov [si].(SREGS)es, ax
    	pop     ax; mov [si].(SREGS)ds, ax

    	lds     si, outregs
    	pop     ax; mov [si].si, ax
    	pop     ax; mov [si].(union REGS)x.flags, ax
    	pop     ax; mov [si].cflag, ax
    	and     word ptr [si].cflag, 1
        pop     ax

    	mov     [si].di, di
    	mov     [si].dx, dx
    	mov     [si].cx, cx
    	mov     [si].bx, bx
    	mov     [si].ax, ax
    	pop     ds
	}
	int returnCode = _AX;
	Dpmi.freeSelector(ExecuteSeg);
	delete code;
    return(returnCode);
}


//=====================================================================
//
//  int86
//
//  handle int86 calls from protected mode
//=====================================================================
int int86(int intNr, REGS far *inregs, REGS far *outregs)
{
	RealInt *code = new RealInt( 0xcd, intNr, 0xcb);    // int x; retf

    void far (far *newCode)(void);

    unsigned ExecuteSeg;
	if (Dpmi.createAlias(FP_SEG(code), ExecuteSeg)!=DPMI_OK) {
		return -1;
	}
    if (Dpmi.setAccessRights(ExecuteSeg, AccessRightsCode)!=DPMI_OK)
        return -1;

	FP_SEG(newCode) = ExecuteSeg;			// use alias effect
    FP_OFF(newCode) = FP_OFF( code );

	asm{
        push    ds
    	lds     si, inregs
    	mov     ax, [si].ax
    	mov     bx, [si].bx
    	mov     cx, [si].cx
    	mov     dx, [si].dx
    	mov     di, [si].di
    	mov     si, [si].si

    	push    bp              /* just to be safe */
    }
    (*newCode)();
    asm {
    	pop     bp

        /* Set register structure with registers */
        push    ax
    	pushf
    	pushf
    	push    si

    	lds     si, outregs
    	pop ax; mov [si].si, ax
    	pop ax; mov [si].(union REGS)x.flags, ax
    	pop ax; mov [si].cflag, ax
    	and     word ptr [si].cflag, 1
        pop ax
    	mov     [si].di, di
    	mov     [si].dx, dx
    	mov     [si].cx, cx
    	mov     [si].bx, bx
    	mov     [si].ax, ax
    	pop     ds
	}
	int returnCode = _AX;
	Dpmi.freeSelector(ExecuteSeg);
	delete code;
    return(returnCode);
}

//=====================================================================
//
//  intdosx
//
//  handle int86 calls from protected mode
//=====================================================================
int intdosx(REGS far *inregs, REGS far *outregs, SREGS far *segregs)
{
	asm{
    	lds     si, segregs
        mov     ax, [si].(SREGS)es
        push ax
        mov     ax, [si].(SREGS)ds
        push ax

    	lds     si, inregs
    	mov     ax, [si].(REGS)x.ax
    	mov     bx, [si].(REGS)x.bx
    	mov     cx, [si].(REGS)x.cx
    	mov     dx, [si].(REGS)x.dx
    	mov     di, [si].(REGS)x.di
    	mov     si, [si].(REGS)x.si
    	pop     ds
    	pop     es

    	push    bp              /* just to be safe */
		int		21h
    	pop     bp

        /* Set register structure with registers */
        push    ax
    	pushf
    	pushf
    	push    si
    	push    ds
    	push    es

    	lds     si, segregs
    	pop     ax; mov [si].(SREGS)es, ax
    	pop     ax; mov [si].(SREGS)ds, ax

    	lds     si, outregs
    	pop     ax; mov [si].si, ax
    	pop     ax; mov [si].(union REGS)x.flags, ax
    	pop     ax; mov [si].cflag, ax
    	and     word ptr [si].cflag, 1
        pop     ax

    	mov     [si].di, di
    	mov     [si].dx, dx
    	mov     [si].cx, cx
    	mov     [si].bx, bx
    	mov     [si].ax, ax
    	pop     ds
	}
	return _AX;
}


//=====================================================================
//
//  intdos
//
//  handle int86 calls from protected mode
//=====================================================================
int intdos(REGS far *inregs, REGS far *outregs)
{
	asm{
        push    ds
    	lds     si, inregs
    	mov     ax, [si].ax
    	mov     bx, [si].bx
    	mov     cx, [si].cx
    	mov     dx, [si].dx
    	mov     di, [si].di
    	mov     si, [si].si

    	push    bp              /* just to be safe */
		int		21h
    	pop     bp

        /* Set register structure with registers */
        push    ax
    	pushf
    	pushf
    	push    si

    	lds     si, outregs
    	pop ax; mov [si].si, ax
    	pop ax; mov [si].(union REGS)x.flags, ax
    	pop ax; mov [si].cflag, ax
    	and     word ptr [si].cflag, 1
        pop ax
    	mov     [si].di, di
    	mov     [si].dx, dx
    	mov     [si].cx, cx
    	mov     [si].bx, bx
    	mov     [si].ax, ax
    	pop     ds
	}
	return _AX;
}
