//***************************************************************************
// Stephen. A. Edwards. July 1994
//
// Example for use of Sounds class.
//
// A simple example to demonstrate the use of the Sounds class.
// As the first argument to the program use the directory and filename
// of a valid VOC format sound file.
//

#include <dos.h>
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>

#include "sounds.h";

Sounds far * 	mysound = NULL;

//*************************************************************************
// Control break handler - if file is playing abort it

int c_break(void)
{
long int Status;

if( mysound )
  {
  Status = mysound->GetPlayStatus();

  if ( Status == FileIsPlaying )
    {
    mysound->Abort();
    printf("\nAborted by Control-Break\n");
    }
  }

return(1);
}

//**************************************************************************
// main program

main(int argc, char * argv[] )
{
enum SIZE 	size = BUF8K;
long int	Status;
char *		error;
int		confirm;
double		Delta;

setcbrk( 1 );
ctrlbrk( c_break );

clrscr();
printf("Sounds Class Example Program\n\n");
printf("This example assumes you have a Sound Blaster or\n");
printf("Sound Blaster Compatible card. Otherwise you can\n");
printf("expect to see some error messages instead of hearing\n");
printf("the sound file. \n");
printf("\n");
printf("Are we ready ? ( type Y or N ) ");

confirm = getch();
if ( confirm == 'Y' || confirm == 'y' )
  {
  if ( argc > 1 )
    {
    mysound = new Sounds( size );

    // report configuration
    mysound->Report();

    if( (Status = mysound->Play( argv[1] )) != 1 )
      {
      printf("*** Error *** Status is %li \n", Status);
      mysound->Error( Status, &error );
      printf("%s \n", error );
      }

    printf("Playing %s, use control-break to abort  \n", argv[1] );
    while( !mysound->Finished ){ printf("."); delay(200); }

    Status = mysound->Elapsed( &Delta );
    if( Status != 1 )
      {
      printf("*** Error *** Status is %li \n", Status);
      mysound->Error( Status, &error );
      printf("%s \n", error );
      }
    else
      {
      printf("\n");
      printf(" Elapsed time was %2.2f seconds ", Delta );
      }

    delete mysound;

    printf("\n");
    printf("Finished - Later Dude \n");
    }
  else
    {
    printf("\n");
    printf("I was expecting the name of a VOC format sound file. \n");
    printf("Please try again with the name of a VOC file. \n");
    printf("Thank You.\n");
    }

  }

}