/*
** editbox.c
**
** Pictor, Version 1.51, Copyright (c) 1992-94 SoftCircuits
** Redistributed by permission.
*/

#include <string.h>
#include "pictor.h"

/*
** Displays an edit box with a the given prompt and calls kbdedit()
** to let the user edit a string. Returns TRUE if the user pressed Enter;
** returns FALSE and buffer is unchanged if the user pressed escape.
*/
int editbox(char *prompt,char *buffer,int maxlen,char *title,
	COLORSTRUCT *colors)
{
	int i,top,left,retval,width,editwidth;

	editwidth = (maxlen + 1);
	width = strlen(prompt) + editwidth + 6;
	i = width - (_PL_columns - 10);
	if(i > 0) {
		editwidth -= i;
		width -= i;
	}

	top = center(3 + 2,_PL_rows);
	left = center(width + 2,_PL_columns);
	wopen(top,left,3 + 2,width + 2,colors->normal,WO_STATICMEM | WO_SHADOW);
	wtitle(title);
	setwpos(2,2);
	wputs(prompt);
	wputs(": [");
	setwpos(2,width - 1);
	wputc(']');

	retval = kbdedit(buffer,top + 2,left + strlen(prompt) + 5,
		editwidth,maxlen,colors);

	wclose();

	return(retval);

} /* editbox */
