/*
** scroll.c
**
** Pictor, Version 1.51, Copyright (c) 1992-94 SoftCircuits
** Redistributed by permission.
*/

#include <dos.h>
#include "pictor.h"

/*
** Scrolls or clears a portion of the screen.
*/
void scroll(int lines,int top,int left,int height,int width)
{
	union REGS regs;

	regs.h.ah = (unsigned char)((lines > 0) ? 0x06 : 0x07);
	regs.h.al = (unsigned char)((lines > 0) ? lines : (-lines));
	regs.h.bh = (unsigned char)_PL_color;
	regs.h.ch = (unsigned char)(top - 1);
	regs.h.dh = (unsigned char)(top + (height - 2));
	regs.h.cl = (unsigned char)(left - 1);
	regs.h.dl = (unsigned char)(left + (width - 2));
	int86(0x10,&regs,&regs);

} /* scroll */
