(*----------------------------------------------------------------
            VLIB.PAS Generated by PARAGen version 2.20          
------------------------------------------------------------------
  PROJECT         : VIDLIB DEMO PROGRAM
  AUTHOR          : Innovative Data Solutions, Inc.
  DATE            : 03/14/1991
  TIME            : 05:21PM
  CODING STYLE    : 2  - [Standard C]
  TAB EXPANSION   : ON
  TABLE           : VLIB.DB - [Fields: 15, Key Fields: 2]
  DATABASE FIELDS          PARADOX                   PARAGEN
                           -------                   -------
                    (01) - Category                  Category                  
                    (02) - Title                     Title                     
                    (03) - Rating                    Rating                    
                    (04) - Director                  Director                  
                    (05) - Stars                     Stars                     
                    (06) - Cast                      Cast                      
                    (07) - Company                   Company                   
                    (08) - Date                      Date                      
                    (09) - Price                     Price                     
                    (10) - Tape                      Tape                      
                    (11) - RunTime                   RunTime                   
                    (12) - Format                    Format                    
                    (13) - Start                     Start                     
                    (14) - Stop                      Stop                      
                    (15) - RunSpeed                  RunSpeed                  
  GENERATED BY    : Innovative Data Solutions, Inc. Paradox Code Generator
                    4318 Stewart Court
                    East Chicago,  IN 46312
                    (219)-397-8952
-----------------------------------------------------------------*)

UNIT VLIB;

(*----------------------------------------------------------------
                     Interface section of UNIT                      
-----------------------------------------------------------------*)

INTERFACE

USES
	PXEngine;

(*----------------------------------------------------------------
                       'Pascal' Access Structure                       
-----------------------------------------------------------------*)

TYPE

	VLIBTABLEENTRY = RECORD		
		Category : string;                                (* KEY FIELD *)
		Title : string;                                   (* KEY FIELD *)
		Rating : string;                                  
		Director : string;                                
		Stars : string;                                   
		Cast : string;                                    
		Company : string;                                 
		DateMonth : Integer;                              
		DateDay : Integer;                                
		DateYear : Integer;                               
		Price : Double;                                   
		Tape : Integer;                                   
		RunTime : Double;                                 
		Format : string;                                  
		Start : Integer;                                  
		Stop : Integer;                                   
		RunSpeed : string;                                
	END;


(*----------------------------------------------------------------
            Copy,Rename,Open,Get and Put Constants and Types                 
-----------------------------------------------------------------*)

	SrcOrDestType = (Source,Destination);
	GetOrPutType =  (Get,Put);

CONST

	NoPassword : String = 'None';
	Buffered : Boolean = False;

	VLIBName : String = 'VLIB';

	
(*----------------------------------------------------------------
	                        Field Size Constants                      
	-----------------------------------------------------------------*)

	FSZCATEGORY : Integer =                 10;       (* KEY FIELD *)
	FSZTITLE : Integer =                    40;       (* KEY FIELD *)
	FSZRATING : Integer =                   5;        
	FSZDIRECTOR : Integer =                 15;       
	FSZSTARS : Integer =                    55;       
	FSZCAST : Integer =                     30;       
	FSZCOMPANY : Integer =                  15;       
	FSZFORMAT : Integer =                   8;        
	FSZRUNSPEED : Integer =                 10;       
	
(*----------------------------------------------------------------
               Engine Handles and Global Variables                
-----------------------------------------------------------------*)

VAR
	VLIBTable : TableHandle;
	VLIBRecord : RecordHandle;
	VLIBCategory : FieldHandle;                            (* KEY FIELD *)
	VLIBTitle : FieldHandle;                               (* KEY FIELD *)
	VLIBRating : FieldHandle;                              
	VLIBDirector : FieldHandle;                            
	VLIBStars : FieldHandle;                               
	VLIBCast : FieldHandle;                                
	VLIBCompany : FieldHandle;                             
	VLIBDate : FieldHandle;                                
	VLIBPrice : FieldHandle;                               
	VLIBTape : FieldHandle;                                
	VLIBRunTime : FieldHandle;                             
	VLIBFormat : FieldHandle;                              
	VLIBStart : FieldHandle;                               
	VLIBStop : FieldHandle;                                
	VLIBRunSpeed : FieldHandle;                            
	VLIBRet : Integer;

(*----------------------------------------------------------------
                       Function Prototypes                        
-----------------------------------------------------------------*)

FUNCTION VLIBError(ErrCode:Integer):Integer;
FUNCTION VLIBTblOpen(Password:String):Integer;
FUNCTION VLIBTblClose:Integer;
FUNCTION VLIBTblCreate(TableSize:Integer):Integer;
FUNCTION VLIBTblEmpty:Integer;
FUNCTION VLIBTblDelete:Integer;
FUNCTION VLIBTblCopy(FileName:String; SrcOrDest:SrcOrDestType):Integer;
FUNCTION VLIBTblRename(DestTable:String):Integer;
FUNCTION VLIBTblAdd(FileName:String; SrcOrDest:SrcOrDestType):Integer;
FUNCTION VLIBTblEncrypt(Password:String):Integer;
FUNCTION VLIBTblDecrypt(Password:String):Integer;
FUNCTION VLIBTblExist(var Exists:Boolean):Integer;
FUNCTION VLIBTblProtected(var IsProtected:Boolean):Integer;
FUNCTION VLIBTblNRecs(var NumRecords:Longint):Integer;
FUNCTION VLIBRecNum(var NumRecords:Longint):Integer;
FUNCTION VLIBSrchKey(SearchMode,NumKeysToSearch:Integer; var RecordVal:VLIBTABLEENTRY):Integer;
FUNCTION VLIBSrchFld(SearchMode:Integer; FieldToSearch:String; var RecordVal:VLIBTABLEENTRY):Integer;
FUNCTION VLIBRecFirst(var RecordVal:VLIBTABLEENTRY):Integer;
FUNCTION VLIBRecNext(var RecordVal:VLIBTABLEENTRY):Integer;
FUNCTION VLIBRecPrev(var RecordVal:VLIBTABLEENTRY):Integer;
FUNCTION VLIBRecLast(var RecordVal:VLIBTABLEENTRY):Integer;
FUNCTION VLIBRecAppend(var RecordVal:VLIBTABLEENTRY):Integer;
FUNCTION VLIBRecInsert(var RecordVal:VLIBTABLEENTRY):Integer;
FUNCTION VLIBRecDelete:Integer;
FUNCTION VLIBRecUpdate(var RecordVal:VLIBTABLEENTRY):Integer;
FUNCTION VLIBRecGoto(RecordNumber:Longint):Integer;
FUNCTION VLIBRecGet(var RecordVal:VLIBTABLEENTRY):Integer;
FUNCTION VLIBFldType(fldHandle:FieldHandle; var FldType:NameString):Integer;
FUNCTION VLIBFldBlank(fldHandle:FieldHandle; var IsBlank:Boolean):Integer;
FUNCTION VLIBRecNFlds(var NumFields:Integer):Integer;
FUNCTION VLIBKeyNFlds(var NumKeyFields:Integer):Integer;
FUNCTION VLIBNetRecLocked(var IsLocked:Boolean):Integer;
FUNCTION VLIBNetTblChanged(var IsChanged:Boolean):Integer;
FUNCTION VLIBNetTblRefresh:Integer;
FUNCTION VLIBNetTblUnlock(LockType:Integer):Integer;
FUNCTION VLIBNetTblLock(LockType:Integer):Integer;
FUNCTION VLIBNetRecUnlock(LckHandle:LockHandle):Integer;
FUNCTION VLIBNetRecLock(var LckHandle:LockHandle):Integer;
FUNCTION VLIBNetRecGotoLock(LckHandle:LockHandle):Integer;
FUNCTION VLIBNetFileUnlock(LockType:Integer):Integer;
FUNCTION VLIBNetFileLock(LockType:Integer):Integer;
FUNCTION VLIBPopulateRecord(var RecordVal:VLIBTABLEENTRY; GetOrPut:GetOrPutType):Integer;

IMPLEMENTATION

(*----------------------------------------------------------------
                          Function Implementation                  
-----------------------------------------------------------------*)

FUNCTION VLIBError(ErrCode:Integer):Integer;

BEGIN
	if (ErrCode > 0) then		
		VLIBError := ErrCode
	else		
		VLIBError := PXSUCCESS;
END;

FUNCTION VLIBTblOpen(Password:String):Integer;

BEGIN
	if (Password <> NoPassword) then		
		BEGIN
			VLIBRet := PXPswAdd(Password);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRet := VLIBError(VLIBRet);
					if (VLIBRet <> PXSUCCESS) then						
						BEGIN
							VLIBTblOpen := VLIBRet;
							Exit;
						END;
				END;
		END;
	VLIBRet := PXTblOpen('VLIB',VLIBTable,0,Buffered);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBTblOpen := VLIBRet;
					Exit;
				END;
		END;
	VLIBRet := PXRecBufOpen(VLIBTable,VLIBRecord);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBTblOpen := VLIBRet;
					Exit;
				END;
		END;
	VLIBRet := PXFldHandle(VLIBTable,'Category',VLIBCategory);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBTblOpen := VLIBRet;
					Exit;
				END;
		END;
	VLIBRet := PXFldHandle(VLIBTable,'Title',VLIBTitle);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBTblOpen := VLIBRet;
					Exit;
				END;
		END;
	VLIBRet := PXFldHandle(VLIBTable,'Rating',VLIBRating);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBTblOpen := VLIBRet;
					Exit;
				END;
		END;
	VLIBRet := PXFldHandle(VLIBTable,'Director',VLIBDirector);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBTblOpen := VLIBRet;
					Exit;
				END;
		END;
	VLIBRet := PXFldHandle(VLIBTable,'Stars',VLIBStars);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBTblOpen := VLIBRet;
					Exit;
				END;
		END;
	VLIBRet := PXFldHandle(VLIBTable,'Cast',VLIBCast);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBTblOpen := VLIBRet;
					Exit;
				END;
		END;
	VLIBRet := PXFldHandle(VLIBTable,'Company',VLIBCompany);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBTblOpen := VLIBRet;
					Exit;
				END;
		END;
	VLIBRet := PXFldHandle(VLIBTable,'Date',VLIBDate);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBTblOpen := VLIBRet;
					Exit;
				END;
		END;
	VLIBRet := PXFldHandle(VLIBTable,'Price',VLIBPrice);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBTblOpen := VLIBRet;
					Exit;
				END;
		END;
	VLIBRet := PXFldHandle(VLIBTable,'Tape',VLIBTape);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBTblOpen := VLIBRet;
					Exit;
				END;
		END;
	VLIBRet := PXFldHandle(VLIBTable,'RunTime',VLIBRunTime);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBTblOpen := VLIBRet;
					Exit;
				END;
		END;
	VLIBRet := PXFldHandle(VLIBTable,'Format',VLIBFormat);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBTblOpen := VLIBRet;
					Exit;
				END;
		END;
	VLIBRet := PXFldHandle(VLIBTable,'Start',VLIBStart);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBTblOpen := VLIBRet;
					Exit;
				END;
		END;
	VLIBRet := PXFldHandle(VLIBTable,'Stop',VLIBStop);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBTblOpen := VLIBRet;
					Exit;
				END;
		END;
	VLIBRet := PXFldHandle(VLIBTable,'RunSpeed',VLIBRunSpeed);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBTblOpen := VLIBRet;
					Exit;
				END;
		END;
	VLIBTblOpen := PXSUCCESS;
END;

FUNCTION VLIBTblClose:Integer;

BEGIN
	VLIBRet := PXTblClose(VLIBTable);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBTblClose := VLIBRet;
					Exit;
				END;
		END;
	VLIBTblClose := PXSUCCESS;
END;

FUNCTION VLIBTblCreate(TableSize:Integer):Integer;

CONST	
	VLIBFields : array[1..15] of NameString =
		(
		'Category',
		'Title',
		'Rating',
		'Director',
		'Stars',
		'Cast',
		'Company',
		'Date',
		'Price',
		'Tape',
		'RunTime',
		'Format',
		'Start',
		'Stop',
		'RunSpeed'
		);

	VLIBTypes : array[1..15] of NameString =
		(
		'A10',
		'A40',
		'A5',
		'A15',
		'A55',
		'A30',
		'A15',
		'D',
		'$',
		'S',
		'N',
		'A8',
		'S',
		'S',
		'A10'
		);

VAR	
	VLIBFieldHandles : WordArray;

BEGIN
	VLIBFieldHandles[1] := 1;
	VLIBFieldHandles[2] := 2;
	if (TableSize > 0) then		
		BEGIN
			VLIBRet := PXTblMaxSize(TableSize);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRet := VLIBError(VLIBRet);
					if (VLIBRet <> PXSUCCESS) then						
						BEGIN
							VLIBTblCreate := VLIBRet;
							Exit;
						END;
				END;
		END;
	VLIBRet := PXTblCreate('VLIB',15,@VLIBFields,@VLIBTypes);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBTblCreate := VLIBRet;
					Exit;
				END;
		END;
	VLIBRet := PXKeyAdd('VLIB',2,VLIBFieldHandles,PRIMARY);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBTblCreate := VLIBRet;
					Exit;
				END;
		END;
	VLIBTblCreate := PXSUCCESS;
END;

FUNCTION VLIBTblEmpty:Integer;

BEGIN
	VLIBRet := PXTblEmpty('VLIB');
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBTblEmpty := VLIBRet;
					Exit;
				END;
		END;
	VLIBTblEmpty := PXSUCCESS;
END;

FUNCTION VLIBTblDelete:Integer;

BEGIN
	VLIBRet := PXTblDelete('VLIB');
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBTblDelete := VLIBRet;
					Exit;
				END;
		END;
	VLIBTblDelete := PXSUCCESS;
END;

FUNCTION VLIBTblCopy(FileName:String; SrcOrDest:SrcOrDestType):Integer;

BEGIN
	if (SrcOrDest = Source) then		
		VLIBRet := PXTblCopy('VLIB',FileName)
	else		
		VLIBRet := PXTblCopy(FileName,'VLIB');
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBTblCopy := VLIBRet;
					Exit;
				END;
		END;
	VLIBTblCopy := PXSUCCESS;
END;

FUNCTION VLIBTblRename(DestTable:String):Integer;

BEGIN
	VLIBRet := PXTblRename('VLIB',DestTable);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBTblRename := VLIBRet;
					Exit;
				END;
		END;
	VLIBTblRename := PXSUCCESS;
END;

FUNCTION VLIBTblAdd(FileName:String; SrcOrDest:SrcOrDestType):Integer;

BEGIN
	if (SrcOrDest = Source) then		
		VLIBRet := PXTblAdd('VLIB',FileName)
	else		
		VLIBRet := PXTblAdd(FileName,'VLIB');
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBTblAdd := VLIBRet;
					Exit;
				END;
		END;
	VLIBTblAdd := PXSUCCESS;
END;

FUNCTION VLIBTblEncrypt(Password:String):Integer;

BEGIN
	VLIBRet := PXTblEncrypt('VLIB',Password);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBTblEncrypt := VLIBRet;
					Exit;
				END;
		END;
	VLIBTblEncrypt := PXSUCCESS;
END;

FUNCTION VLIBTblDecrypt(Password:String):Integer;

BEGIN
	VLIBRet := PXPswAdd(Password);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBTblDecrypt := VLIBRet;
					Exit;
				END;
		END;
	VLIBRet := PXTblDecrypt('VLIB');
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBTblDecrypt := VLIBRet;
					Exit;
				END;
		END;
	VLIBTblDecrypt := PXSUCCESS;
END;

FUNCTION VLIBTblExist(var Exists:Boolean):Integer;

BEGIN
	VLIBRet := PXTblExist('VLIB',Exists);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBTblExist := VLIBRet;
					Exit;
				END;
		END;
	VLIBTblExist := PXSUCCESS;
END;

FUNCTION VLIBTblProtected(var IsProtected:Boolean):Integer;

BEGIN
	VLIBRet := PXTblProtected('VLIB',IsProtected);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBTblProtected := VLIBRet;
					Exit;
				END;
		END;
	VLIBTblProtected := PXSUCCESS;
END;

FUNCTION VLIBTblNRecs(var NumRecords:Longint):Integer;

BEGIN
	VLIBRet := PXTblNRecs(VLIBTable,NumRecords);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBTblNRecs := VLIBRet;
					Exit;
				END;
		END;
	VLIBTblNrecs := PXSUCCESS;
END;

FUNCTION VLIBRecNum(var NumRecords:Longint):Integer;

BEGIN
	VLIBRet := PXRecNum(VLIBTable,NumRecords);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRecNum := VLIBRet;
					Exit;
				END;
		END;
	VLIBRecNum := PXSUCCESS;
END;

FUNCTION VLIBSrchKey(SearchMode,NumKeysToSearch:Integer; var RecordVal:VLIBTABLEENTRY):Integer;

VAR	
	NKeysToSearch : Integer;

BEGIN
	NKeysToSearch := NumKeysToSearch;
	VLIBRet := PXRecBufEmpty(VLIBRecord);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBSrchKey := VLIBRet;
					Exit;
				END;
		END;
	repeat		
		case NKeysToSearch of			
			2 :				
				BEGIN
					VLIBRet := PXPutAlpha(VLIBRecord,VLIBTitle,RecordVal.Title);
					if (VLIBRet <> PXSUCCESS) then						
						BEGIN
							VLIBRet := VLIBError(VLIBRet);
							if (VLIBRet <> PXSUCCESS) then								
								BEGIN
									VLIBSrchKey := VLIBRet;
									Exit;
								END;
						END;
				END;
			1 :				
				BEGIN
					VLIBRet := PXPutAlpha(VLIBRecord,VLIBCategory,RecordVal.Category);
					if (VLIBRet <> PXSUCCESS) then						
						BEGIN
							VLIBRet := VLIBError(VLIBRet);
							if (VLIBRet <> PXSUCCESS) then								
								BEGIN
									VLIBSrchKey := VLIBRet;
									Exit;
								END;
						END;
				END;
		END;
		NKeysToSearch := NKeysToSearch - 1;
	until NKeysToSearch = 0;

	VLIBRet := PXSrchKey(VLIBTable,VLIBRecord,NumKeysToSearch,SearchMode);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBSrchKey := VLIBRet;
					Exit;
				END;
		END;
	VLIBRet := PXRecGet(VLIBTable,VLIBRecord);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBSrchKey := VLIBRet;
					Exit;
				END;
		END;
	VLIBRet := VLIBPopulateRecord(RecordVal,GET);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBSrchKey := VLIBRet;
					Exit;
				END;
		END;
	VLIBSrchKey := PXSUCCESS;
END;

FUNCTION VLIBSrchFld(SearchMode:Integer; FieldToSearch:String; var RecordVal:VLIBTABLEENTRY):Integer;

VAR	
	FldHandle : FIELDHANDLE;
	Paradate : Longint;
BEGIN
	VLIBRet := PXFldHandle(VLIBTable,FieldToSearch,FldHandle);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBSrchFld := VLIBRet;
					Exit;
				END;
		END;
	VLIBRet := PXRecBufEmpty(VLIBRecord);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBSrchFld := VLIBRet;
					Exit;
				END;
		END;
	case FldHandle of		
		1 :			
			VLIBRet := PXPutAlpha(VLIBRecord,VLIBCategory,RecordVal.Category);
		2 :			
			VLIBRet := PXPutAlpha(VLIBRecord,VLIBTitle,RecordVal.Title);
		3 :			
			VLIBRet := PXPutAlpha(VLIBRecord,VLIBRating,RecordVal.Rating);
		4 :			
			VLIBRet := PXPutAlpha(VLIBRecord,VLIBDirector,RecordVal.Director);
		5 :			
			VLIBRet := PXPutAlpha(VLIBRecord,VLIBStars,RecordVal.Stars);
		6 :			
			VLIBRet := PXPutAlpha(VLIBRecord,VLIBCast,RecordVal.Cast);
		7 :			
			VLIBRet := PXPutAlpha(VLIBRecord,VLIBCompany,RecordVal.Company);
		8 :			
			BEGIN
				VLIBRet := PXDateEncode(RecordVal.DateMonth,RecordVal.DateDay,RecordVal.DateYear,ParaDate);
				if (VLIBRet <> PXSUCCESS) then					
					BEGIN
						VLIBRet := VLIBError(VLIBRet);
						if (VLIBRet <> PXSUCCESS) then							
							BEGIN
								VLIBSrchFld := VLIBRet;
								Exit;
							END;
					END;
				VLIBRet := PXPutDate(VLIBRecord,VLIBDate,ParaDate);
			END;
		9 :			
			VLIBRet := PXPutDoub(VLIBRecord,VLIBPrice,RecordVal.Price);
		10 :			
			VLIBRet := PXPutShort(VLIBRecord,VLIBTape,RecordVal.Tape);
		11 :			
			VLIBRet := PXPutDoub(VLIBRecord,VLIBRunTime,RecordVal.RunTime);
		12 :			
			VLIBRet := PXPutAlpha(VLIBRecord,VLIBFormat,RecordVal.Format);
		13 :			
			VLIBRet := PXPutShort(VLIBRecord,VLIBStart,RecordVal.Start);
		14 :			
			VLIBRet := PXPutShort(VLIBRecord,VLIBStop,RecordVal.Stop);
		15 :			
			VLIBRet := PXPutAlpha(VLIBRecord,VLIBRunSpeed,RecordVal.RunSpeed);
	END;
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBSrchFld := VLIBRet;
					Exit;
				END;
		END;
	VLIBRet := PXSrchFld(VLIBTable,VLIBRecord,FldHandle,SearchMode);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBSrchFld := VLIBRet;
					Exit;
				END;
		END;
	VLIBRet := PXRecGet(VLIBTable,VLIBRecord);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBSrchFld := VLIBRet;
					Exit;
				END;
		END;
	VLIBRet := VLIBPopulateRecord(RecordVal,GET);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBSrchFld := VLIBRet;
					Exit;
				END;
		END;
	VLIBSrchFld := PXSUCCESS;
END;

FUNCTION VLIBRecFirst(var RecordVal:VLIBTABLEENTRY):Integer;

BEGIN
	VLIBRet := PXRecFirst(VLIBTable);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRecFirst := VLIBRet;
					Exit;
				END;
		END;
	VLIBRet := PXRecGet(VLIBTable,VLIBRecord);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRecFirst := VLIBRet;
					Exit;
				END;
		END;
	VLIBRet := VLIBPopulateRecord(RecordVal,GET);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRecFirst := VLIBRet;
					Exit;
				END;
		END;
	VLIBRecFirst := PXSUCCESS;
END;

FUNCTION VLIBRecNext(var RecordVal:VLIBTABLEENTRY):Integer;

BEGIN
	VLIBRet := PXRecNext(VLIBTable);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRecNext := VLIBRet;
					Exit;
				END;
		END;
	VLIBRet := PXRecGet(VLIBTable,VLIBRecord);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRecNext := VLIBRet;
					Exit;
				END;
		END;
	VLIBRet := VLIBPopulateRecord(RecordVal,GET);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRecNext := VLIBRet;
					Exit;
				END;
		END;
	VLIBRecNext := PXSUCCESS;
END;

FUNCTION VLIBRecPrev(var RecordVal:VLIBTABLEENTRY):Integer;

BEGIN
	VLIBRet := PXRecPrev(VLIBTable);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRecPrev := VLIBRet;
					Exit;
				END;
		END;
	VLIBRet := PXRecGet(VLIBTable,VLIBRecord);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRecPrev := VLIBRet;
					Exit;
				END;
		END;
	VLIBRet := VLIBPopulateRecord(RecordVal,GET);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRecPrev := VLIBRet;
					Exit;
				END;
		END;
	VLIBRecPrev := PXSUCCESS;
END;

FUNCTION VLIBRecLast(var RecordVal:VLIBTABLEENTRY):Integer;

BEGIN
	VLIBRet := PXRecLast(VLIBTable);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRecLast := VLIBRet;
					Exit;
				END;
		END;
	VLIBRet := PXRecGet(VLIBTable,VLIBRecord);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRecLast := VLIBRet;
					Exit;
				END;
		END;
	VLIBRet := VLIBPopulateRecord(RecordVal,GET);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRecLast := VLIBRet;
					Exit;
				END;
		END;
	VLIBRecLast := PXSUCCESS;
END;

FUNCTION VLIBRecAppend(var RecordVal:VLIBTABLEENTRY):Integer;

BEGIN
	VLIBRet := PXRecBufEmpty(VLIBRecord);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRecAppend := VLIBRet;
					Exit;
				END;
		END;
	VLIBRet := VLIBPopulateRecord(RecordVal,PUT);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRecAppend := VLIBRet;
					Exit;
				END;
		END;
	VLIBRet := PXRecAppend(VLIBTable,VLIBRecord);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRecAppend := VLIBRet;
					Exit;
				END;
		END;
	VLIBRecAppend := PXSUCCESS;
END;

FUNCTION VLIBRecInsert(var RecordVal:VLIBTABLEENTRY):Integer;

BEGIN
	VLIBRet := PXRecBufEmpty(VLIBRecord);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRecInsert := VLIBRet;
					Exit;
				END;
		END;
	VLIBRet := VLIBPopulateRecord(RecordVal,PUT);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRecInsert := VLIBRet;
					Exit;
				END;
		END;
	VLIBRet := PXRecInsert(VLIBTable,VLIBRecord);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRecInsert := VLIBRet;
					Exit;
				END;
		END;
	VLIBRecInsert := PXSUCCESS;
END;

FUNCTION VLIBRecDelete:Integer;

BEGIN
	VLIBRet := PXRecDelete(VLIBTable);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRecDelete := VLIBRet;
					Exit;
				END;
		END;
	VLIBRecDelete := PXSUCCESS;
END;

FUNCTION VLIBRecUpdate(var RecordVal:VLIBTABLEENTRY):Integer;

BEGIN
	VLIBRet := PXRecBufEmpty(VLIBRecord);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRecUpdate := VLIBRet;
					Exit;
				END;
		END;
	VLIBRet := VLIBPopulateRecord(RecordVal,PUT);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRecUpdate := VLIBRet;
					Exit;
				END;
		END;
	VLIBRet := PXRecUpdate(VLIBTable,VLIBRecord);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRecUpdate := VLIBRet;
					Exit;
				END;
		END;
	VLIBRecUpdate := PXSUCCESS;
END;

FUNCTION VLIBRecGoto(RecordNumber:Longint):Integer;

BEGIN
	VLIBRet := PXRecGoto(VLIBTable,RecordNumber);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRecGoto := VLIBRet;
					Exit;
				END;
		END;
	VLIBRecGoto := PXSUCCESS;
END;

FUNCTION VLIBRecGet(var RecordVal:VLIBTABLEENTRY):Integer;

BEGIN
	VLIBRet := PXRecBufEmpty(VLIBRecord);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRecGet := VLIBRet;
					Exit;
				END;
		END;
	VLIBRet := PXRecGet(VLIBTable,VLIBRecord);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRecGet := VLIBRet;
					Exit;
				END;
		END;
	VLIBRet := VLIBPopulateRecord(RecordVal,GET);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRecGet := VLIBRet;
					Exit;
				END;
		END;
	VLIBRecGet := PXSUCCESS;
END;

FUNCTION VLIBFldType(fldHandle:FieldHandle; var FldType:NameString):Integer;

BEGIN
	VLIBRet := PXFldType(VLIBTable,fldHandle,FldType);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBFldType := VLIBRet;
					Exit;
				END;
		END;
	VLIBFldType := PXSUCCESS;
END;

FUNCTION VLIBFldBlank(fldHandle:FieldHandle; var IsBlank:Boolean):Integer;

BEGIN
	VLIBRet := PXFldBlank(VLIBRecord,fldHandle,IsBlank);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBFldBlank := VLIBRet;
					Exit;
				END;
		END;
	VLIBFldBlank := PXSUCCESS;
END;

FUNCTION VLIBRecNFlds(var NumFields:Integer):Integer;

BEGIN
	VLIBRet := PXRecNFlds(VLIBTable,NumFields);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRecNFlds := VLIBRet;
					Exit;
				END;
		END;
	VLIBRecNFlds := PXSUCCESS;
END;

FUNCTION VLIBKeyNFlds(var NumKeyFields:Integer):Integer;

BEGIN
	VLIBRet := PXKeyNFlds(VLIBTable,NumKeyFields);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBKeyNFlds := VLIBRet;
					Exit;
				END;
		END;
	VLIBKeyNFlds := PXSUCCESS;
END;

FUNCTION VLIBNetRecLocked(var IsLocked:Boolean):Integer;
BEGIN
	VLIBRet := PXNetRecLocked(VLIBTable,IsLocked);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBNetRecLocked := VLIBRet;
					Exit;
				END;
		END;
	VLIBNetRecLocked := PXSUCCESS;
END;

FUNCTION VLIBNetTblChanged(var IsChanged:Boolean):Integer;
BEGIN
	VLIBRet := PXNetTblChanged(VLIBTable,IsChanged);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBNetTblChanged := VLIBRet;
					Exit;
				END;
		END;
	VLIBNetTblChanged := PXSUCCESS;
END;

FUNCTION VLIBNetTblRefresh:Integer;
BEGIN
	VLIBRet := PXNetTblRefresh(VLIBTable);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBNetTblRefresh := VLIBRet;
					Exit;
				END;
		END;
	VLIBNetTblRefresh := PXSUCCESS;
END;

FUNCTION VLIBNetTblUnlock(LockType:Integer):Integer;
BEGIN
	VLIBRet := PXNetTblUnlock(VLIBTable,LockType);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBNetTblUnLock := VLIBRet;
					Exit;
				END;
		END;
	VLIBNetTblUnlock := PXSUCCESS;
END;

FUNCTION VLIBNetTblLock(LockType:Integer):Integer;
BEGIN
	VLIBRet := PXNetTblLock(VLIBTable,LockType);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBNetTblLock := VLIBRet;
					Exit;
				END;
		END;
	VLIBNetTblLock := PXSUCCESS;
END;

FUNCTION VLIBNetRecUnlock(LckHandle:LockHandle):Integer;
BEGIN
	VLIBRet := PXNetRecUnlock(VLIBTable,LckHandle);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBNetRecUnLock := VLIBRet;
					Exit;
				END;
		END;
	VLIBNetRecUnlock := PXSUCCESS;
END;

FUNCTION VLIBNetRecLock(var LckHandle:LockHandle):Integer;
BEGIN
	VLIBRet := PXNetRecLock(VLIBTable,Lckhandle);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBNetRecLock := VLIBRet;
					Exit;
				END;
		END;
	VLIBNetRecLock := PXSUCCESS;
END;

FUNCTION VLIBNetRecGotoLock(LckHandle:LockHandle):Integer;
BEGIN
	VLIBRet := PXNetRecGotoLock(VLIBTable,LckHandle);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBNetRecGotoLock := VLIBRet;
					Exit;
				END;
		END;
	VLIBNetRecGotoLock := PXSUCCESS;
END;

FUNCTION VLIBNetFileUnlock(LockType:Integer):Integer;
BEGIN
	VLIBRet := PXNetFileUnlock('VLIB.db',LockType);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBNetFileUnlock := VLIBRet;
					Exit;
				END;
		END;
	VLIBNetFileUnlock := PXSUCCESS;
END;

FUNCTION VLIBNetFileLock(LockType:Integer):Integer;
BEGIN
	VLIBRet := PXNetFileLock('VLIB.db',LockType);
	if (VLIBRet <> PXSUCCESS) then		
		BEGIN
			VLIBRet := VLIBError(VLIBRet);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBNetFileLock := VLIBRet;
					Exit;
				END;
		END;
	VLIBNetFileLock := PXSUCCESS;
END;

FUNCTION VLIBPopulateRecord(var RecordVal:VLIBTABLEENTRY; GetOrPut:GetOrPutType):Integer;
VAR	
	Paradate : Longint;

BEGIN
	if (GetOrPut = Put) then		
		BEGIN
			VLIBRet := PXPutAlpha(VLIBRecord,VLIBCategory,RecordVal.Category);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRet := VLIBError(VLIBRet);
					if (VLIBRet <> PXSUCCESS) then						
						BEGIN
							VLIBPopulateRecord := VLIBRet;
							Exit;
						END;
				END;
			VLIBRet := PXPutAlpha(VLIBRecord,VLIBTitle,RecordVal.Title);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRet := VLIBError(VLIBRet);
					if (VLIBRet <> PXSUCCESS) then						
						BEGIN
							VLIBPopulateRecord := VLIBRet;
							Exit;
						END;
				END;
			VLIBRet := PXPutAlpha(VLIBRecord,VLIBRating,RecordVal.Rating);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRet := VLIBError(VLIBRet);
					if (VLIBRet <> PXSUCCESS) then						
						BEGIN
							VLIBPopulateRecord := VLIBRet;
							Exit;
						END;
				END;
			VLIBRet := PXPutAlpha(VLIBRecord,VLIBDirector,RecordVal.Director);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRet := VLIBError(VLIBRet);
					if (VLIBRet <> PXSUCCESS) then						
						BEGIN
							VLIBPopulateRecord := VLIBRet;
							Exit;
						END;
				END;
			VLIBRet := PXPutAlpha(VLIBRecord,VLIBStars,RecordVal.Stars);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRet := VLIBError(VLIBRet);
					if (VLIBRet <> PXSUCCESS) then						
						BEGIN
							VLIBPopulateRecord := VLIBRet;
							Exit;
						END;
				END;
			VLIBRet := PXPutAlpha(VLIBRecord,VLIBCast,RecordVal.Cast);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRet := VLIBError(VLIBRet);
					if (VLIBRet <> PXSUCCESS) then						
						BEGIN
							VLIBPopulateRecord := VLIBRet;
							Exit;
						END;
				END;
			VLIBRet := PXPutAlpha(VLIBRecord,VLIBCompany,RecordVal.Company);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRet := VLIBError(VLIBRet);
					if (VLIBRet <> PXSUCCESS) then						
						BEGIN
							VLIBPopulateRecord := VLIBRet;
							Exit;
						END;
				END;
			VLIBRet := PXDateEncode(RecordVal.DateMonth,RecordVal.DateDay,RecordVal.DateYear,ParaDate);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRet := VLIBError(VLIBRet);
					if (VLIBRet <> PXSUCCESS) then						
						BEGIN
							VLIBPopulateRecord := VLIBRet;
							Exit;
						END;
				END;
			VLIBRet := PXPutDate(VLIBRecord,VLIBDate,ParaDate);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRet := VLIBError(VLIBRet);
					if (VLIBRet <> PXSUCCESS) then						
						BEGIN
							VLIBPopulateRecord := VLIBRet;
							Exit;
						END;
				END;
			VLIBRet := PXPutDoub(VLIBRecord,VLIBPrice,RecordVal.Price);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRet := VLIBError(VLIBRet);
					if (VLIBRet <> PXSUCCESS) then						
						BEGIN
							VLIBPopulateRecord := VLIBRet;
							Exit;
						END;
				END;
			VLIBRet := PXPutShort(VLIBRecord,VLIBTape,RecordVal.Tape);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRet := VLIBError(VLIBRet);
					if (VLIBRet <> PXSUCCESS) then						
						BEGIN
							VLIBPopulateRecord := VLIBRet;
							Exit;
						END;
				END;
			VLIBRet := PXPutDoub(VLIBRecord,VLIBRunTime,RecordVal.RunTime);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRet := VLIBError(VLIBRet);
					if (VLIBRet <> PXSUCCESS) then						
						BEGIN
							VLIBPopulateRecord := VLIBRet;
							Exit;
						END;
				END;
			VLIBRet := PXPutAlpha(VLIBRecord,VLIBFormat,RecordVal.Format);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRet := VLIBError(VLIBRet);
					if (VLIBRet <> PXSUCCESS) then						
						BEGIN
							VLIBPopulateRecord := VLIBRet;
							Exit;
						END;
				END;
			VLIBRet := PXPutShort(VLIBRecord,VLIBStart,RecordVal.Start);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRet := VLIBError(VLIBRet);
					if (VLIBRet <> PXSUCCESS) then						
						BEGIN
							VLIBPopulateRecord := VLIBRet;
							Exit;
						END;
				END;
			VLIBRet := PXPutShort(VLIBRecord,VLIBStop,RecordVal.Stop);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRet := VLIBError(VLIBRet);
					if (VLIBRet <> PXSUCCESS) then						
						BEGIN
							VLIBPopulateRecord := VLIBRet;
							Exit;
						END;
				END;
			VLIBRet := PXPutAlpha(VLIBRecord,VLIBRunSpeed,RecordVal.RunSpeed);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRet := VLIBError(VLIBRet);
					if (VLIBRet <> PXSUCCESS) then						
						BEGIN
							VLIBPopulateRecord := VLIBRet;
							Exit;
						END;
				END;
		END
	else		
		BEGIN
			VLIBRet := PXGetAlpha(VLIBRecord,VLIBCategory,RecordVal.Category);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRet := VLIBError(VLIBRet);
					if (VLIBRet <> PXSUCCESS) then						
						BEGIN
							VLIBPopulateRecord := VLIBRet;
							Exit;
						END;
				END;
			VLIBRet := PXGetAlpha(VLIBRecord,VLIBTitle,RecordVal.Title);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRet := VLIBError(VLIBRet);
					if (VLIBRet <> PXSUCCESS) then						
						BEGIN
							VLIBPopulateRecord := VLIBRet;
							Exit;
						END;
				END;
			VLIBRet := PXGetAlpha(VLIBRecord,VLIBRating,RecordVal.Rating);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRet := VLIBError(VLIBRet);
					if (VLIBRet <> PXSUCCESS) then						
						BEGIN
							VLIBPopulateRecord := VLIBRet;
							Exit;
						END;
				END;
			VLIBRet := PXGetAlpha(VLIBRecord,VLIBDirector,RecordVal.Director);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRet := VLIBError(VLIBRet);
					if (VLIBRet <> PXSUCCESS) then						
						BEGIN
							VLIBPopulateRecord := VLIBRet;
							Exit;
						END;
				END;
			VLIBRet := PXGetAlpha(VLIBRecord,VLIBStars,RecordVal.Stars);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRet := VLIBError(VLIBRet);
					if (VLIBRet <> PXSUCCESS) then						
						BEGIN
							VLIBPopulateRecord := VLIBRet;
							Exit;
						END;
				END;
			VLIBRet := PXGetAlpha(VLIBRecord,VLIBCast,RecordVal.Cast);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRet := VLIBError(VLIBRet);
					if (VLIBRet <> PXSUCCESS) then						
						BEGIN
							VLIBPopulateRecord := VLIBRet;
							Exit;
						END;
				END;
			VLIBRet := PXGetAlpha(VLIBRecord,VLIBCompany,RecordVal.Company);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRet := VLIBError(VLIBRet);
					if (VLIBRet <> PXSUCCESS) then						
						BEGIN
							VLIBPopulateRecord := VLIBRet;
							Exit;
						END;
				END;
			VLIBRet := PXGetDate(VLIBRecord,VLIBDate,ParaDate);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRet := VLIBError(VLIBRet);
					if (VLIBRet <> PXSUCCESS) then						
						BEGIN
							VLIBPopulateRecord := VLIBRet;
							Exit;
						END;
				END;
			VLIBRet := PXDateDecode(ParaDate,RecordVal.DateMonth,RecordVal.DateDay,RecordVal.DateYear);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRet := VLIBError(VLIBRet);
					if (VLIBRet <> PXSUCCESS) then						
						BEGIN
							VLIBPopulateRecord := VLIBRet;
							Exit;
						END;
				END;
			VLIBRet := PXGetDoub(VLIBRecord,VLIBPrice,RecordVal.Price);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRet := VLIBError(VLIBRet);
					if (VLIBRet <> PXSUCCESS) then						
						BEGIN
							VLIBPopulateRecord := VLIBRet;
							Exit;
						END;
				END;
			VLIBRet := PXGetShort(VLIBRecord,VLIBTape,RecordVal.Tape);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRet := VLIBError(VLIBRet);
					if (VLIBRet <> PXSUCCESS) then						
						BEGIN
							VLIBPopulateRecord := VLIBRet;
							Exit;
						END;
				END;
			VLIBRet := PXGetDoub(VLIBRecord,VLIBRunTime,RecordVal.RunTime);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRet := VLIBError(VLIBRet);
					if (VLIBRet <> PXSUCCESS) then						
						BEGIN
							VLIBPopulateRecord := VLIBRet;
							Exit;
						END;
				END;
			VLIBRet := PXGetAlpha(VLIBRecord,VLIBFormat,RecordVal.Format);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRet := VLIBError(VLIBRet);
					if (VLIBRet <> PXSUCCESS) then						
						BEGIN
							VLIBPopulateRecord := VLIBRet;
							Exit;
						END;
				END;
			VLIBRet := PXGetShort(VLIBRecord,VLIBStart,RecordVal.Start);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRet := VLIBError(VLIBRet);
					if (VLIBRet <> PXSUCCESS) then						
						BEGIN
							VLIBPopulateRecord := VLIBRet;
							Exit;
						END;
				END;
			VLIBRet := PXGetShort(VLIBRecord,VLIBStop,RecordVal.Stop);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRet := VLIBError(VLIBRet);
					if (VLIBRet <> PXSUCCESS) then						
						BEGIN
							VLIBPopulateRecord := VLIBRet;
							Exit;
						END;
				END;
			VLIBRet := PXGetAlpha(VLIBRecord,VLIBRunSpeed,RecordVal.RunSpeed);
			if (VLIBRet <> PXSUCCESS) then				
				BEGIN
					VLIBRet := VLIBError(VLIBRet);
					if (VLIBRet <> PXSUCCESS) then						
						BEGIN
							VLIBPopulateRecord := VLIBRet;
							Exit;
						END;
				END;
		END;
	VLIBPopulateRecord := PXSUCCESS;
END;

END.
