/* ------------------------------------------------------------------------ */
/*		                          KBD.C                                     */
/*                                                                          */
/* 		      See pg. 79 of Systems Programming In Turbo C                  */
/*                                                                          */
/* ------------------------------------------------------------------------ */

#pragma inline			/* notify compiler of inline assembly language */

#include <dos.h>
#include "kbd.h"

void KbdFlush()
/*
	This function flushes the keyboard buffer maintained by the BIOS
*/
{
a01:;
	asm	mov	ah, 01;		/* BIOS service 1: determine if key is ready */
	asm int 16h;		/* BIOS keyboard services */
	asm jz a02;			/* ZF = 1 means no key ready */

	asm mov ah, 00;		/* BIOS service 0: read key */
	asm int 16h;

	asm jmp a01;		/* return for another key */
a02:;
}


int KbdGetShift()
/*
	This function returns the BIOS shift status word
*/
{
	return *((int far *)0x00400017);
}


void KbdSetShift(int ShiftStat)
/*
	This function sets the BIOS shift status word
*/
{
	*((int far *)0x00400017) = ShiftStat;
}

int KbdGetC()
/*
	This function reads a key using the BIOS. The return value contains:
		High-order byte:	Extended code
		Low-order byte:		ASCII value
*/
{
	_AH = 0;				/* BIOS service 0: read keyboard */
	geninterrupt (0x16);	/* BIOS keyboard services */
	return (_AX);			/* Extended code/ASCII value returned in AH/AL */
}