/*
	RULER.C - Display a ruler on the screen.
			  Original idea taken from Duane A. Bowen and his
			  @LAST TSR program.
*/

#include <stdio.h>
#include <dos.h>
#include <kbd.h>

void Ruler(void);

typedef int ROW[80];
ROW far *Video;
static int Buffer[25][80];
extern int Row, Col;
extern int HighlightClr;

static void InitBuf(void);
static void PutRow(void);
static void DrawRuler(void);

void Ruler()
{
	int dx, dy;

	ScrGetCur(&dx, &dy, 0);
	Video = MK_FP (*(char far *)0x00400049 == 7 ? 0xb000 : 0xb800, 0);
	InitBuf();

	for (;;)	{
		DrawRuler();
		Video[Row][Col] = Buffer[Row][Col];
		switch (KbdGetC())	{
			case UP:
				PutRow();
				if (--Row < 0) Row = 24;
				break;
			case DN:
				PutRow();
				if (++Row > 24) Row = 0;
				break;
			case RIGHT:
				if (++Col > 79) Col = 0;
				break;
			case LEFT:
				if (--Col < 0) Col = 79;
				break;
			case HOME:
				Col = 0;
				break;
			case END:
				Col = 79;
				break;
			case PGUP:
				PutRow();
				Row = 0;
				break;
			case PGDN:
				PutRow();
				Row = 24;
				break;
			case RET:
			case ESC:
				PutRow();
				ScrSetCur(dx, dy, 0);
				return;
		}
	}
}

static void DrawRuler()
{
	PutStr(0,Row, HighlightClr,
"  Column = %2d, Row = %2d      %c %c %c %c,  <Esc> - Quit      Column = %2d, Row = %2d  ",
	Col, Row, 27, 24, 25, 26, Col, Row);
}

static void PutRow()
{
	register int c;

	for (c=0; c<=79; c++)
		Video[Row][c] = Buffer[Row][c];
}

static void InitBuf()
{
	int VideoSeg;

	VideoSeg = *(char far *)0x00400049 == 7 ? 0xb000 : 0xb800;

	movedata(VideoSeg, 0, FP_SEG((char far *)Buffer),
			 FP_OFF((char far *)Buffer), 4000);
}

