/*
	KEYCODES.C - Display scan and ascii keyboard codes
*/

#include <kbd.h>

extern int BorderClr;
extern int TitleClr;
extern int TextClr;
extern int FooterClr;

void KeyCodes(void);

void KeyCodes()
{
	int Key, HiByte, LoByte;
	char ch;

	ScrPush();
	ShadowBox(9,6,28,14, 2, BorderClr);
	PutStr(10,7, TitleClr,   "  Keyboard Codes  ");
	PutStr(9,8, BorderClr,  "͵");
	PutStr(16,9, FooterClr,        "Scan  Ascii ");
	PutStr(10,10, FooterClr, " Hex:");
	PutStr(10,11, FooterClr, " Dec:");
	PutStr(15,10, TextClr,   "  00    00   ");
	PutStr(15,11, TextClr,   "  00    00   ");
	PutStr(9,12, BorderClr, "͵");
	PutStr(10,13, FooterClr, "<Esc> twice Quits ");

	for (;;)	{
		Key = KbdGetC();
		HiByte = (Key&0xff00) >> 8;
		LoByte = Key&0x00ff;
		ch = LoByte;
		if (ch == 0) ch = ' ';
		PutStr(10,9,  TextClr, "  %c   ", ch);
		PutStr(15,10, TextClr, "  %02X    %02X   ", HiByte, LoByte);
		PutStr(15,11, TextClr, "  %-03d", HiByte);
		PutStr(19,11, TextClr, "    %-03d  ", LoByte);
		if (Key == ESC)	{
			if (KbdGetC() == ESC)	{
				ScrPop(1);
				return;
			}
		}
	}
}