/*
	BOXCHR.C - Display the ASCII chars and codes for the four box types.
*/

#include <stdio.h>
#include <kbd.h>

extern int BorderClr;
extern int TitleClr;
extern int TextClr;
extern int FooterClr;

extern int BoxIdx;

void BoxCodes(void);

struct Box {
	int HL;
	int VL;
	int ULC;
	int URC;
	int LLC;
	int LRC;
	int TT;
	int BT;
	int LT;
	int RT;
	int XT;
};

struct Box B[] = {
	{196,179,218,191,192,217,194,193,195,180,197},
	{205,186,201,187,200,188,203,202,204,185,206},
	{205,179,213,184,212,190,209,207,198,181,216},
	{196,186,214,183,211,189,210,208,199,182,215}
	};

static void DrawMenu(void);
static void WriteChars(int i);

void BoxCodes()
{
	ScrPush();
	DrawMenu();

	for (;;)	{
		WriteChars(BoxIdx);
		switch(KbdGetC())	{
			case ESC:
				ScrPop(1);
				return;
			default:
				BoxIdx++;
				if (BoxIdx > 3) BoxIdx = 0;
				break;
		}
	}
}

static void DrawMenu()
{
	ShadowBox(18,1,38,15, 2, BorderClr);
	PutStr(19,2, TitleClr,   "     Box Chars     ");
	PutStr(18,3, BorderClr, "͵");
	PutStr(18,13,BorderClr, "͵");
	PutStr(19,14,FooterClr,  " Any key  Esc-Quit ");
}

static void WriteChars(int i)
{
	PutStr(22,4, FooterClr, "%d", B[i].HL);
	PutStr(32,4, FooterClr, "%d", B[i].VL);
	PutStr(22,5, TextClr, "%c%c%c", B[i].HL,B[i].HL,B[i].HL);
	PutStr(33,5, TextClr, "%c", B[i].VL);
	PutStr(27,6, FooterClr, "%d", B[i].TT);
	PutStr(20,7, FooterClr, "%d", B[i].ULC);
	PutStr(23,7, TextClr, "%c%c  %c%c%c  %c%c",
			B[i].ULC,B[i].HL, B[i].HL,B[i].TT,B[i].HL, B[i].HL,B[i].URC);
	PutStr(34,7, FooterClr, "%d", B[i].URC);

	PutStr(20,9, FooterClr, "%d", B[i].LT);
	PutStr(23,9, TextClr, "%c%c  %c%c%c  %c%c",
			B[i].LT,B[i].HL, B[i].HL,B[i].XT,B[i].HL, B[i].HL,B[i].RT);
	PutStr(34,9, FooterClr, "%d", B[i].RT);
	PutStr(27,10, FooterClr, "%d", B[i].XT);

	PutStr(20,11, FooterClr, "%d", B[i].LLC);
	PutStr(23,11, TextClr, "%c%c  %c%c%c  %c%c",
			B[i].LLC,B[i].HL, B[i].HL,B[i].BT,B[i].HL, B[i].HL,B[i].LRC);
	PutStr(34,11, FooterClr, "%d", B[i].LRC);
	PutStr(27,12, FooterClr, "%d", B[i].BT);
}