// OOSTRING.H
//
// Class library for strings

///////////////////////////////////////////////////////////////////////////

#ifndef __cplusplus
#error Must use C++ for the type string.
#endif

#ifndef __OOSTRING_H
#define __OOSTRING_H

#ifndef NULL
#if defined(__TINY__) || defined(__SMALL__) || defined(__MEDIUM__)
#define NULL    0
#else
#define NULL    0L
#endif
#endif

#if   defined(__SMALL__) || defined(__MEDIUM__)
#define _CLASSTYPE  near
#elif defined(__COMPACT__) || defined(__LARGE__)
#define _CLASSTYPE  far
#else
#define _CLASSTYPE  huge
#endif


///////////////////////////////////////////////////////////////////////////

#include ".\stacks\object.h"
#include <iostream.h>
#include <iomanip.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

///////////////////////////////////////////////////////////////////////////

class _CLASSTYPE string : public object
{
  protected:

  char *string_ptr;                    // character array
  int size;                            // allocated space
  int length;                          // length of string

  public:

  string() : string_ptr(NULL), size(0), length(0) {};  // void constructor
  string(char *str);                   // char array
  string(char ch);                     // character
  string(const string &src);           // copy constructor
  ~string()                            // destructor
  {
    delete string_ptr;                 // release storage space
  }

  string& operator=(const string &src);// assignment operator
  friend string operator+(const string &str1, const string &str2);
  string operator+=(const string &str);
  string operator+();                  // unary operator +
  string operator-();                  // unary operator -
  string& operator++();                // convert to uppercase
  string& operator--();                // convert to lowercase
  char& operator[](const int index);   // allow access to chars in string.  Can be used as an lvalue
  friend int operator>(const string &str1, const string &str2)
  {
    return (strcmp(str1.string_ptr, str2.string_ptr) > 0);
  }  // end of operator >

  friend int operator<(const string &str1, const string &str2)
  {
    return (strcmp(str1.string_ptr, str2.string_ptr) < 0);
  }  // end of operator <

  friend int operator==(const string &str1, const string &str2)
  {
    return (strcmp(str1.string_ptr, str2.string_ptr) == 0);
  }  // end of operator ==

  friend int operator!=(const string &str1, const string &str2)
  {
    return !(strcmp(str1.string_ptr, str2.string_ptr) == 0);
  }  // end of operator !=

  friend int operator>=(const string &str1, const string &str2)
  {
    return ((str1 > str2) || (str1 == str2));
  }  // end of operator >=

  friend int operator<=(const string &str1, const string &str2)
  {
    return ((str1 < str2) || (str1 == str2));
  }  // end of operator <=

  friend ostream& operator<<(ostream &stream, const string &str);
  friend ostream& operator<<(ostream &stream, const string *str);
  friend istream& operator>>(istream& stream, string& str);

  int setsize(const int newsize);
  int len() { return (length);}
  void getline(istream& stream, const int maxlen = 80);
};  // end of class string

#endif