// *************************************************************** //
// Filename:    lb.cpp                                             //
//                                                                 //
// Date:        Nov 29, 1993                                       //
//                                                                 //
// Description:                                                    //
// *************************************************************** //
#include "MPD.h"

TIconListBox::TIconListBox(TWindow *parent, int resId, TModule *module) :
  TListBox(parent, resId, module)
{
}

TIconListBox::TIconListBox(TWindow *parent, int id, int x, int y, 
  int w, int h, TModule *module) :
  TListBox(parent, id, x, y, w, h, module)
{
  Attr.Style |= WS_BORDER | WS_VSCROLL | WS_TABSTOP | WS_VISIBLE | 
    LBS_NOTIFY | LBS_OWNERDRAWVARIABLE | LBS_NOINTEGRALHEIGHT | 
    LBS_HASSTRINGS;
  Attr.Style &= ~LBS_SORT;
}

void TIconListBox::ODADrawEntire(DRAWITEMSTRUCT &drawInfo)
{
  DrawEntry(drawInfo);
}

void TIconListBox::ODAFocus(DRAWITEMSTRUCT &drawInfo)
{
  ::DrawFocusRect(drawInfo.hDC, &drawInfo.rcItem);
}

void TIconListBox::ODASelect(DRAWITEMSTRUCT &drawInfo)
{
  ::InvertRect(drawInfo.hDC, &drawInfo.rcItem);
}

void TIconListBox::DrawEntry(DRAWITEMSTRUCT &drawInfo)
{
  // erase the item
  ::FillRect(drawInfo.hDC, &drawInfo.rcItem, 
    (HBRUSH)::GetStockObject(LTGRAY_BRUSH));

  ItemData *data = (ItemData *)GetItemData(drawInfo.itemID);
  // draw the icon
  HICON hIcon = LoadIcon(*GetApplication(), data->Icon);
  DrawIcon(drawInfo.hDC, drawInfo.rcItem.left, drawInfo.rcItem.top, hIcon);
  DestroyIcon(hIcon);

  // draw the text
  char buffer[512];
  GetString(buffer, drawInfo.itemID);
  RECT tempRect = drawInfo.rcItem;
  tempRect.left = GetSystemMetrics(SM_CXICON) + 2;
  ::DrawText(drawInfo.hDC, buffer, -1, &tempRect,
    DT_SINGLELINE | DT_VCENTER);

  if (drawInfo.itemState & ODS_FOCUS)
  {
    ::DrawFocusRect(drawInfo.hDC, &drawInfo.rcItem);
  }
  if (drawInfo.itemState & ODS_SELECTED)
  {
    ::InvertRect(drawInfo.hDC, &drawInfo.rcItem);
  }
}

void TIconListBox::AddItem(const char *text, TResID icon, TResID dialog)
{
  ItemData *data = new ItemData;
  data->Icon = icon;
  data->Dialog = dialog;
  int index = AddString(text);
  SetItemData(index, (DWORD)data);
}

void TIconListBox::CleanupWindow()
{
  for (int i=0; i<GetCount(); i++)
  {
    ItemData *data = (ItemData *)GetItemData(i);
    delete data;
  }
  // new stuff here
  TListBox::CleanupWindow();
}


// --------------------------------------------------------------- //
// Response table                                                  //
// --------------------------------------------------------------- //
DEFINE_RESPONSE_TABLE1(TIconListBox, TListBox)
  EV_WM_KEYDOWN,
  EV_WM_GETDLGCODE,
END_RESPONSE_TABLE;

// --------------------------------------------------------------- //
// Make sure the listbox receives a tab.                           //
// --------------------------------------------------------------- //
UINT TIconListBox::EvGetDlgCode(MSG *msg)
{
  return TListBox::EvGetDlgCode(msg) | DLGC_WANTTAB;
}

// --------------------------------------------------------------- //
// Process the tab key.                                            //
// --------------------------------------------------------------- //
void TIconListBox::EvKeyDown(UINT key, UINT repeatCount, UINT flags)
{
  if (key == VK_TAB)
  {
    GetApplication()->PumpWaitingMessages();
    if (IsShiftKeyDown())
      SetFocusToDlgLastCtrl();
    else
      SetFocusToDlgFirstCtrl();
  }
  else
    TListBox::EvKeyDown(key, repeatCount, flags);
}

