// NSCROLL.H - header file for numeric edit control scroll buttons
// 
//

#ifndef NSCROLL_H_
#define NSCROLL_H_

#ifndef __OWL_H
#include <owl.h>
#endif

#ifndef __STATIC_H
#include <static.h>
#endif

_CLASSDEF(NumberScroller)

class NumberScroller : public TWindow
{
	public:
//
//	constructor #1 - use this if there is an OWL object representing
//	the control to which the number scroller is attatched (in a window
//	or a dialog).
//
	NumberScroller(	PTStatic	TheStatic,
					int			nMaxValue,
                    int			nMinValue = 0,
					PTModule 	AModule = NULL);
//
//	constructor #2 - for use when no OWL object exists to represent
//	the relevant control (in a dialog represented by a TDialog (or
//	derived) object)
//
	NumberScroller( int				ResourceID,
					PTDialog		TheDialog,
					int				nMaxValue,
                    int				nMinValue = 0,
					PTModule 		AModule = NULL);
//
//	destructor -
//
	~NumberScroller();
//
//	member functions to allow amendment of the maximum and minimum
//	permissible values for the control.  The contents of the control
//	will be modified if they are outside the allowed range.
//
//	Return value is the old max or min value as appropriate
// 
	int SetMaxValue(int nMaxValue);
	int SetMinValue(int nMinValue);

	protected:

//	perform instance initialisation common to both constructors.
	void Init(PTModule AModule);

//	read and write the value from/to the associated control
	void SetValue(int nValue);
	int  GetValue();

//	OWL inherited functions
    void SetupWindow();
	void Paint(HDC hdc, PAINTSTRUCT _FAR &ps);

// 	Windows message handling
	void WMLButtonDown(RTMessage Msg) =	[WM_FIRST + WM_LBUTTONDOWN];
	void WMLButtonUp(RTMessage Msg) =	[WM_FIRST + WM_LBUTTONUP];
    void WMTimer(RTMessage Msg) =		[WM_FIRST + WM_TIMER];

	private:
//	static members:
//
//	The HBITMAP is loaded from resource when the first NumberScroller is
//	instantiated, and the GDI object is deleted when the last NumberScroller
//	is destroyed.
//
	static int		nInstanceCount;
	static HBITMAP	hBM;
//
//	data members:
//
//	variables providing connection to the associated control...
// 
	int				idControl;
	PTStatic		pTheStatic;
	HWND			hwndControl;
//
//	allowed range...
//
	int 			nMin, nMax;
//
//	internal control...
	int 			nStatus, nTimerTicks;
	BOOL			bCapturingMouse;
	UINT			nTimerId;
};

#endif //NSCROLL_H_