//	demo.cpp - source file for NumberScroller demo
//
//

#include <owl.h>
#include <edit.h>

#include "nscroll.h"

// Define application class derived from  TApplication
class Tdemo : public TApplication
{
public:
  Tdemo(LPSTR AName, HINSTANCE hInstance, HINSTANCE hPrevInstance,
                   LPSTR lpCmdLine, int nCmdShow)
    : TApplication(AName, hInstance, hPrevInstance, lpCmdLine, nCmdShow) {};
    virtual void InitMainWindow();
};

// Declare TMainWindow, a TWindow descendant
class TMainWindow : public TWindow
{
public:
	PTEdit p;
//
//	Declare a pointer to a NumberScroller in the parent window class...
//
	PNumberScroller ps;

   TMainWindow(PTWindowsObject AParent, LPSTR ATitle);
   ~TMainWindow();
   virtual void DIALOG(RTMessage Msg) = [CM_FIRST + 100];

   virtual void GetWindowClass(WNDCLASS _FAR & AWndClass);
   virtual LPSTR GetClassName();
};


/****************************************************
 * TMainWindow implementations: 
 ****************************************************/

// Define TMainWindow, a TWindow constructor
TMainWindow::TMainWindow(PTWindowsObject AParent, LPSTR ATitle)
                         : TWindow(AParent, ATitle)
{
   AssignMenu("demo");
	p = new TEdit(this, 101, "", 20, 20, 100, 22, 0, FALSE);
//
//	set the pointer to the address of a new NumberScroller (this one is
//	created using a pointer to the OWL TEdit object representing the control
//	with which this NumberScroller is to be associated)
//
	ps = new NumberScroller(p, 100, -100);
}

// Define TMainWindow destructor
TMainWindow::~TMainWindow()
{
	delete p;
//	destroy the NumberScroller
	delete ps;
}

LPSTR TMainWindow::GetClassName()
{
   return "MainWindow";
}

void TMainWindow::GetWindowClass(WNDCLASS _FAR & AWndClass)
{
   TWindow::GetWindowClass(AWndClass);
   AWndClass.hbrBackground = CreateSolidBrush(0xc0c0c0);
}

_CLASSDEF(TDIALOG_1Dlg)

// Declare TDIALOG_1Dlg, a TDialog descendant
class TDIALOG_1Dlg : public TDialog 
{
public:
//
//	Declare pointers to the NumberScrollers in the parent dialog class...
//
	PNumberScroller p,p2;

   PTEdit Edit101;

   TDIALOG_1Dlg(PTWindowsObject AParent, LPSTR AName);
   ~TDIALOG_1Dlg();
	virtual void WMCtlColor(RTMessage Msg) = [WM_FIRST + WM_CTLCOLOR];
};

// Define TDIALOG_1Dlg, a TDialog constructor
TDIALOG_1Dlg::TDIALOG_1Dlg(PTWindowsObject AParent, LPSTR AName)
               :TDialog(AParent, AName)
{
   Edit101 = new TEdit(this, 101, 0);
//
//	set the pointers to the addresses of new NumberScrollers.
//
//	The first one is created using a pointer to the OWL TEdit object
//	representing the control.
//
//	The second one is created using the resource ID of a control which is
//	not represented by an OWL object.
//
   p = new NumberScroller(Edit101, 100);
   p2 = new NumberScroller(102,this,100);
}

// Define TDIALOG_1Dlg destructor
TDIALOG_1Dlg::~TDIALOG_1Dlg()
{
//	destroy the NumberScrollers
	delete p;
    delete p2;

   delete Edit101;
}

void TDIALOG_1Dlg::WMCtlColor(RTMessage Msg)
{
    if(Msg.LP.Hi != CTLCOLOR_EDIT) {
		SetBkColor((HDC)Msg.WParam, 0xc0c0c0);
		Msg.Result = (long) (HBRUSH) GetStockObject(LTGRAY_BRUSH);
	}
	else
    	DefWndProc(Msg);
}

void TMainWindow::DIALOG(RTMessage)
{
   // Execute modal dialog
   GetModule()->ExecDialog( new TDIALOG_1Dlg(this, "DIALOG_1"));
}

/***************************************************
 * TdemoApp method implementations:
 ***************************************************/

// Construct the Tdemo's MainWindow of type TMainWindow
void Tdemo::InitMainWindow()
{
   MainWindow = new TMainWindow(NULL, Name);
}

// Main program
int PASCAL WinMain(HINSTANCE hInstance,
                   HINSTANCE hPrevInstance,
                   LPSTR lpCmdLine,
                   int nCmdShow)
{
   Tdemo demo ("NumberScroller demonstration", hInstance, hPrevInstance,
      lpCmdLine, nCmdShow);

   demo.Run();

   return demo.Status;
}
