/********************************************/
/*                                          */
/*    Name:NBTEST.C                         */
/*                                          */
/*    Purpose: TX and RX a buffer to or     */
/*    	       from a Netbios Partner	    */
/*                                          */
/*    Revision: 01.00.00                    */
/*        Date: 06/20/91                    */
/*                                          */
/********************************************/

/* Include Statements */
#include <stdio.h>
#include <conio.h>
#include <alloc.h>
#include <dos.h>
#include <dir.h>
#include <string.h>
#include "nb_api.c"

/* Global Variables */
FILE *err;
unsigned int length;
int ret,mode;
unsigned errors,bytes,ok;
unsigned char loc_name_num,session_lsn;
char *buffer1,*buffer2,loc_name[16],rem_name[16];

/* Global Structures */
#define CLIENT		0
#define HOST		1
#define MAX_BUFF	63000
struct NCB ncb;

/* Function Definitions */
void start_session(void);
void test(void);
void clean_up(void);

void main(int argc, char *argv[])
{

	/******* Allocate Memory for two test Buffers ******/
	buffer1=(char *)farcalloc(MAX_BUFF+10,sizeof(char));
	if(buffer1==NULL){
		printf("ERROR: Unable to allocate first buffer!\r\n");
		exit(-1);
		};
	buffer2=(char *)farcalloc(MAX_BUFF+10,sizeof(char));
	if(buffer2==NULL){
		printf("ERROR: Unable to allocate second buffer!\r\n");
		exit(-1);
		};

	/*** Open Error Log *****/
	err=fopen("NB_ERROR.LOG","a+b");
	if(err==NULL){
		cprintf("ERROR: Unable to open Error Log\r\n");
		farfree(buffer1);
		farfree(buffer2);
		};

	/*** Display Logo ****/
	textcolor(WHITE);
	cprintf("\r\n\r\n         Netbios Test Utility\r\n");
	cprintf("     Dawn Development Corp.   1991\r\n");
	if(argc<2){
		cprintf("sytax: nbtest <[H]ost/[C]lient>\r\n");
		farfree(buffer1);
		farfree(buffer2);
		exit(0);
		};
	if(!check_nb_install()){
		cprintf("\r\nERROR: Netbios NOT Installed..\r\n");
		exit(-2);
		};

	/*** Check Command Line ***/
	argv[1][0]=toupper(argv[1][0]);
	if(argv[1][0]=='H'){
		mode=HOST;
		}
	else{
		mode=CLIENT;
		};

	test();

	/******** Clean Up ***********/
	farfree(buffer1);
	farfree(buffer2);
	fcloseall();
	clean_up();

}

void start_session(void)
{
	/***************** START SESSION ************************/
	if(mode==HOST){
		strcpy(loc_name,"HOST");
		strcpy(rem_name,"CLIENT");
		}
	else{
		strcpy(loc_name,"CLIENT");
		strcpy(rem_name,"HOST");
		};
	cprintf("\r\nAdding LOCAL Name to Table\r\n");

	/*********** Add Local Name and Call or Listen for Remote *********/
	ncb=add_name(loc_name);
	if(ncb.NCB_RETCODE!=0){
		cprintf("ERROR: Unable to ADD Local Name!\r\n");
		cprintf("ERROR: %Xh\r\n",ncb.NCB_RETCODE);
		exit(-1);
		};
	loc_name_num=ncb.NCB_NUM;

	if(mode==HOST){
		ncb=listen(rem_name,loc_name,1250);
		if(ncb.NCB_RETCODE!=0){
			cprintf("ERROR: Unable to Listen for Remote!\r\n");
			cprintf("ERROR: %Xh\r\n",ncb.NCB_RETCODE);
			clean_up();
			};
		session_lsn=ncb.NCB_LSN;
		}
	else{
		ncb=call(rem_name,loc_name,60);
		if(ncb.NCB_RETCODE!=0){
			cprintf("ERROR: Unable to Call Host!\r\n");
			cprintf("ERROR: %Xh\r\n",ncb.NCB_RETCODE);
			clean_up();
			};
		session_lsn=ncb.NCB_LSN;
		};

}

void test(void)
{
	start_session();
	if(mode==CLIENT){
		memset(&buffer1,'C',MAX_BUFF);
		ncb=send((char *)&buffer1,MAX_BUFF,session_lsn);
		if(ncb.NCB_RETCODE!=0){
			cprintf("ERROR: Send Failed!\r\n");
			cprintf("ERROR: %02Xh\r\n",ncb.NCB_RETCODE);
			clean_up();
			};
		ncb=receive((char *)&buffer2,MAX_BUFF,session_lsn);
		if(ncb.NCB_RETCODE!=0){
			cprintf("ERROR: Receive Failed!\r\n");
			cprintf("ERROR: %02Xh\r\n",ncb.NCB_RETCODE);
			clean_up();
			};
		ret=memcmp(buffer1,buffer2,MAX_BUFF);
		if(ret!=0){
			error++;
			}
		else{
			ok++;
			bytes+=MAX_BUFF;
			};
		}
	/*** Do Host Mode Stuff ****/
	else{

		};

}

void clean_up(void)
{
	if(mode==CLIENT){
		printf("\r\nTerminating Session\r\n");
		ncb=hang_up(session_lsn);
		if(ncb.NCB_RETCODE!=0){
			cprintf("\r\nERROR: Unable to Hang Up!\r\n");
			cprintf("ERROR: %Xh\r\n",ncb.NCB_RETCODE);
			clean_up();
			};
		};

	printf("\r\nRemoving Local Name from Table...\r\n");
	ncb=del_name(loc_name);
	if(ncb.NCB_RETCODE!=0){
		cprintf("\r\nERROR: Unable to Remove Name!\r\n");
		cprintf("ERROR: %Xh\r\n",ncb.NCB_RETCODE);
		clean_up();
		};

	exit(0);

}

