/*  MAINMOUS.CPP:
    Test program for MOUSHAND.ZIP.

    compile with:

      bcc -ml mainmous.cpp moushand.cpp     // real mode
      bcc -ml -WX mainmous.cpp moushand.cpp // DPMI16
      bcc32 -WX mainmous.cpp moushand.cpp   // DPMI32

    Tested with BC++ 4.02 and Power Pack version 1.0.
*/
#include <stdio.h>
#include <conio.h>
#include <dos.h>


extern short  event,
              buttonState,
              x,
              y,
              vticks,
              hticks;


void  storeDS( void );
void  installMouseHandler( void );
void  removeMouseHandler( void );

int main( void )
{
#ifndef __DPMI32__
#ifdef  __DPMI16__
  /*  It's illegal to write to the code segment under DPMI16, so
      we need to create an alias for the code segment.  By
      default, this alias is a data selector.
  */
  asm
  {
    push ds
    push es

    /*  Keep data segment for global variables in es.
    */
    push ds
    pop  es

    /*  Create data selector alias for code selector.  Assumes
        success.
    */
    mov ax, 0Ah
    mov bx, SEG storeDS
    int 31h

    /*  Store the global variable DS.
    */
    mov ds, ax
    mov ds:[storeDS], es

    /*  Free alias selector.
    */
    mov ax, 0Ah
    mov bx, ds
    int 31h

    pop es
    pop ds
  }

#else ifdef __DPMI16__
  /*  In real mode, we can write to code, with no violation errors.
      Note that the extra code to move the SEG of storeDS is a
      precaution in case the storeDS function is not in the same
      compilation module as this function.
  */
  asm
  {
    push es
    push ax
    mov ax, SEG storeDS
    mov es, ax
    mov es:[storeDS], ds
    pop ax
    pop es
  }

#endif  def __DPMI16__ else

#else ifndef  __DPMI32__
  /*  In 32-bits, we can store the data segment in a global
      variable because we can get to global data through cs.
  */
  asm
  {
    extrn _DataSegment : word
    mov ds:_DataSegment, ds
  }

#endif  ndef __DPMI32__ else

  asm {
    mov ax, 0
    int 33h
  }

  installMouseHandler();

  while( !kbhit() )
  {
#ifdef  __DPMI32__
    /*  Accessing extern variables under 32-bits can cause bad loc
        for fixupp messages.  This code gets around the problem by
        declaring local varaibles that can get the value of the
        externs.  Then we can print the local variables.
    */
    short levent,
          lbuttonState,
          lx,
          ly,
          lvticks,
          lhticks;

    asm
    {
      extrn _event        : word
      extrn _buttonState  : word
      extrn _x            : word
      extrn _y            : word
      extrn _vticks       : word
      extrn _hticks       : word

      mov ax, _event
      mov levent, ax
      mov ax, _buttonState
      mov lbuttonState, ax
      mov ax, _x
      mov lx, ax
      mov ax, _y
      mov ly, ax
      mov ax, _vticks
      mov lvticks, ax
      mov ax, _hticks
      mov lhticks, ax
    }

    printf( "%04X %04X (%6d,%6d)  (%6d,%6d)\n", levent,
      lbuttonState, lx, ly, lvticks, lhticks );

#else ifdef __DPMI32__
    printf( "%04X %04X (%6d,%6d)  (%6d,%6d)\n", event,
      buttonState, x, y, vticks, hticks );

#endif  ifdef __DPMI32__ else
  }

  removeMouseHandler();

  return 0;
}
