// Copyright (C) 1992 James H. Price, All rights reserved
//
//  MSGTEST.CPP
//
//    Test program for MessageLine
//

#define Uses_MsgBox
#define Uses_TEvent
#define Uses_TApplication
#define Uses_TKeys
#define Uses_TRect
#define Uses_TMenu
#define Uses_TMenuBar
#define Uses_TMenuItem
#define Uses_TStatusLine
#define Uses_TStatusItem
#define Uses_TStatusDef
#define Uses_TDeskTop
#include <tv.h>

#include "msgline.h"

const cmAbout = 100;
const cmTest  = 101;

class Shell : public TApplication {

public:

	Shell();
	static TMenuBar *initMenuBar( TRect r );
	static TStatusLine *initStatusLine( TRect r );
	void handleEvent( TEvent& event );

private:

	void About();
	void Test();
};

Shell::Shell() : TProgInit (
			&Shell::initStatusLine,
			&Shell::initMenuBar,
			&Shell::initDeskTop
			)
{
}

TMenuBar *Shell::initMenuBar( TRect r )
{
	r.b.y = r.a.y + 1;

	TMenuItem& mI =
		*new TMenuItem( "~T~est", cmTest, kbNoKey, hcNoContext );

	return new TMenuBar( r, new TMenu( mI ) );
}

TStatusLine *Shell::initStatusLine( TRect r )
{
	r.a.y = r.b.y - 1;

	TStatusLine *sL = new TStatusLine( r,
		*new TStatusDef(0, 0xFFFF) +
			*new TStatusItem( 0, kbF10, cmMenu ) +
			*new TStatusItem( "~Alt-X~ Quit", kbAltX, cmQuit ) );

	return sL;
}

void Shell::handleEvent( TEvent &event )
{
	TApplication::handleEvent(event);

	if (event.what == evCommand)
	{
		switch (event.message.command)
		{
			case cmAbout:
				About();
				break;
			case cmTest:
				Test();
				break;
			default:
				break;
		}
	}
}

void Shell::About()
{
	messageBox( "\003MessageLine Demo",
		mfInformation | mfOKButton );
}

void Shell::Test()
{
	// show status line
	ShowStatusLine( "Executing Test() . . ." );

	messageBox( "\003Don't look here, look at the status line!",
		mfInformation | mfOKButton );

	// clear it
	ClearStatusLine();
}

int main()
{
	TEvent init;
	init.what = evCommand;
	init.message.command = cmAbout;   // pop up about box

	Shell shell;
	shell.putEvent(init);
	shell.run();
	return 0;
}

