// msg.hpp - Dan Rempel, June 1994

#ifndef		MSG_HPP_DVR
#define		MSG_HPP_DVR

// If you feel nested includes are a no-no, remove this and
// rely on order of inclusion.
#include	<iostream.h>

	//--------------------------------------------------------------

// The msgbuf class, derived from streambuf, is a virtual base class whose
// sync() function uses the user-supplied outFunc() to actually write (draw,
// whatever) inserted characters.

class msgbuf : public streambuf
{
public:
	msgbuf( void ( *outFunc )( const char *const s, int n ) );
	msgbuf( int buflen, void ( *outFunc )( const char *const s, int n ) );
	msgbuf( char *buffer, int len,
			void ( *outFunc )( const char *const s, int n ) );
	msgbuf( unsigned char *buffer, int len,
			void ( *outFunc )( const char *const s, int n ) );

	virtual streambuf 	*setbuf( char *buffer, int len );
	virtual int			sync();

protected:
	virtual int 		overflow( int );
	virtual int			underflow() { return EOF; }
	enum	{ DEFAULT_BUF_SIZE = 256 };

	void ( *OutFunction )( const char *const str, int n );

private:
	// prevent copying or assignment of a msgbuf
	msgbuf();
	msgbuf( const msgbuf & );
	msgbuf &operator = ( const msgbuf & );
};

	//--------------------------------------------------------------

class	msgstream : public ostream_withassign
{
public:
	msgstream( void ( *outFunc )( const char *const s, int n ) = 0 );
	msgstream( int len, void ( *outFunc )( const char *const s, int n ) = 0 );
	msgstream( char *buffer, int len,
			   void ( *outFunc )( const char *const s, int n ) );
	msgstream( unsigned char *buffer, int len,
			   void ( *outFunc )( const char *const s, int n ) );

private:
	msgbuf	Buf;
};

#endif		// #ifndef		MSG_HPP_DVR
