/*  Project monitor
    
    Copyright  1994. All Rights Reserved.

    SUBSYSTEM:    monitor.exe Application
    FILE:         montrapp.cpp
    AUTHOR:       Philippe Goutier


    OVERVIEW
    ========
    Source file for implementation of monitorApp (TApplication).      
*/


#include <owl\owlpch.h>
#pragma hdrstop


#include "montrapp.h"
#include "mntrabtd.h"                        // Definition of about dialog.


//{{monitorApp Implementation}}
void  RegisterDebugMonitor();
char* GetInterMem();
monitorApp *_App;

/* -------------------------------------------------------------------------- */

void CALLBACK timerProc(HWND, UINT, UINT, DWORD)
{
	char *s = GetInterMem();
	if (s && *s)
	{
		TEditFile *client = TYPESAFE_DOWNCAST(_App->GetMainWindow()->GetClientWindow(), TEditFile);     // Client window for the frame.

		HANDLE handle = OpenMutex(MUTEX_ALL_ACCESS, 0, "WritingInfo");
		if (handle)
		{
			WaitForSingleObject(handle,INFINITE);
			CloseHandle(handle);
		}
		handle = CreateMutex(NULL, 1, "ReadingInfo");

		client->Insert(s);
		*s = 0;

		ReleaseMutex(handle);
		CloseHandle(handle);
	}
}

/* -------------------------------------------------------------------------- */

//
// Build a response table for all messages/commands handled
// by the application.
//
DEFINE_RESPONSE_TABLE1(monitorApp, TApplication)
//{{monitorAppRSP_TBL_BEGIN}}
    EV_COMMAND(CM_FILENEW, CmFileNew),
    EV_COMMAND(CM_FILEOPEN, CmFileOpen),
    EV_COMMAND(CM_FILECLOSE, CmFileClose),
    EV_COMMAND(CM_HELPABOUT, CmHelpAbout),
//{{monitorAppRSP_TBL_END}}
END_RESPONSE_TABLE;




//////////////////////////////////////////////////////////
// monitorApp
// =====
//
monitorApp::monitorApp () : TApplication("monitor")
{

    // Common file file flags and filters for Open/Save As dialogs.  Filename and directory are
    // computed in the member functions CmFileOpen, and CmFileSaveAs.
    FileData.Flags = OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT;
    FileData.SetFilter("All Files (*.*)|*.*|");

    // INSERT>> Your constructor code here.

}


monitorApp::~monitorApp ()
{
    // INSERT>> Your destructor code here.

}


void monitorApp::SetupSpeedBar (TDecoratedFrame *frame)
{ 
    //
    // Create default toolbar New and associate toolbar buttons with commands.
    //   
    TControlBar* cb = new TControlBar(frame);
    cb->Insert(*new TButtonGadget(CM_FILENEW, CM_FILENEW));
    cb->Insert(*new TButtonGadget(CM_FILEOPEN, CM_FILEOPEN));
    cb->Insert(*new TButtonGadget(CM_FILESAVE, CM_FILESAVE));
    cb->Insert(*new TSeparatorGadget(6));
    cb->Insert(*new TButtonGadget(CM_EDITCUT, CM_EDITCUT));
    cb->Insert(*new TButtonGadget(CM_EDITCOPY, CM_EDITCOPY));
    cb->Insert(*new TButtonGadget(CM_EDITPASTE, CM_EDITPASTE));
    cb->Insert(*new TSeparatorGadget(6));
    cb->Insert(*new TButtonGadget(CM_EDITUNDO, CM_EDITUNDO));
    cb->Insert(*new TSeparatorGadget(6));
    cb->Insert(*new TButtonGadget(CM_EDITFIND, CM_EDITFIND));
    cb->Insert(*new TButtonGadget(CM_EDITFINDNEXT, CM_EDITFINDNEXT));

    // Add fly-over help hints.
    cb->SetHintMode(TGadgetWindow::EnterHints);

    frame->Insert(*cb, TDecoratedFrame::Top);
}


//////////////////////////////////////////////////////////
// monitorApp
// =====
// Application intialization.
//
void monitorApp::InitMainWindow ()
{
    SDIDecFrame *frame = new SDIDecFrame(0, GetName(), 0, FALSE);

    nCmdShow = nCmdShow != SW_SHOWMINIMIZED ? SW_SHOWNORMAL : nCmdShow;

    //
    // Assign ICON w/ this application.
    //
    frame->SetIcon(this, IDI_SDIAPPLICATION);

    //
    // Menu associated with window and accelerator table associated with table.
    //
    frame->AssignMenu(SDI_MENU);
    
    //
    // Associate with the accelerator table.
    //
    frame->Attr.AccelTable = SDI_MENU;

    SetupSpeedBar(frame);
  
    SetMainWindow(frame);
}


//////////////////////////////////////////////////////////
// monitorApp
// ===========
// Menu File New command
void monitorApp::CmFileNew ()
{
    TEditFile *client = TYPESAFE_DOWNCAST(GetMainWindow()->GetClientWindow(), TEditFile);     // Client window for the frame.
    client->NewFile();
}


//////////////////////////////////////////////////////////
// monitorApp
// ===========
// Menu File Open command
void monitorApp::CmFileOpen ()
{
    //
    // Display standard Open dialog box to select a file name.
    //
    *FileData.FileName = 0;

    TEditFile *client = TYPESAFE_DOWNCAST(GetMainWindow()->GetClientWindow(), TEditFile);     // Client window for the frame.
    if (client->CanClose())
        if (TFileOpenDialog(GetMainWindow(), FileData).Execute() == IDOK)
            OpenFile();
}


void monitorApp::OpenFile (const char *fileName)
{
    if (fileName)
        lstrcpy(FileData.FileName, fileName);

    TEditFile *client = TYPESAFE_DOWNCAST(GetMainWindow()->GetClientWindow(), TEditFile);     // Client window for the frame.
    client->ReplaceWith(FileData.FileName);
}


//////////////////////////////////////////////////////////
// monitorApp
// =====
// Menu File Close command
void monitorApp::CmFileClose ()
{
    CmFileNew();
}


//{{SDIDecFrame Implementation}}


SDIDecFrame::SDIDecFrame (TWindow *parent, const char far *title, TWindow *clientWnd, BOOL trackMenuSelection, TModule *module)
    : TDecoratedFrame(parent, title, clientWnd == 0 ? new TEditFile(0, 0, 0) : clientWnd, trackMenuSelection, module)
{
    // INSERT>> Your constructor code here.

}


SDIDecFrame::~SDIDecFrame ()
{
    // INSERT>> Your destructor code here.

}


//////////////////////////////////////////////////////////
// monitorApp
// ===========
// Menu Help About monitor.exe command
void monitorApp::CmHelpAbout ()
{
    //
    // Show the modal dialog.
    //
    monitorAboutDlg(MainWindow).Execute();
}


int OwlMain (int , char* [])
{
    monitorApp     App;
    _App = &App;
    int             result;

    result = App.Run();

    return result;
}



void SDIDecFrame::SetupWindow ()
{
    TDecoratedFrame::SetupWindow();

    // INSERT>> Your code here.
	SetWindowPos(HWND_TOPMOST,
		::GetSystemMetrics(SM_CXFULLSCREEN) - 200,
		::GetSystemMetrics(SM_CYFULLSCREEN) - 400,
		200,
		400,
		0);
	SetTimer (1000, 10, timerProc);

}

