/*   ********************************************************************   *
  ***                                                   unix compatible  ***
 *    MetalBase 3.0....................................................     *
 *                                                                          *
 *    Multi-user simultaneous use of relations (On multi-user hardware)     *
 *    Users may have many relations open at once, even the same one!        *
 *    Unlimited length records (Really!  Just redefine BUF_LEN!)            *
 *    Up to 20 indicies per relation, 5 fields max per composite index      *
 *    Up to 4.2 billion records per relation                                *
 *    Bizzare intermittent bugs, just like the expensive programs           *
 *    And, unless they're weird, your kids will eat it                      *
 *                                                               /\         *
 *    Written starting in August 1989, by Huan-Ti            rj /  \        *
 *                                                             /    \       *
 *   "Ye hath mushrooms for $1.99 a pound.  Ye art             \    /       *
 *    truly a Calvinist."                                       \  / tp     *
 *                       -- II Calvin 7:1                        \/         *
  ***                                                                    ***
 *   ********************************************************************   */

#include "stdinc.h"

#ifndef BUF_LEN            /* Maximum possible needed buffer (Length = 1 +  */
#define BUF_LEN 256        /* record_length + 13*number_of_indicies         */
#endif                     /* If needed, redefine before #including         */

#ifndef MAX_REL            /* Maximum possible # of relations open at once, */
#define MAX_REL 5          /* for this user.  DOES NOT CHANGE STDIO'S # of  */
#endif                     /* FILES OPEN AT ONCE (#_of_rel + 3)             */

#ifndef MAX_FLDS           /* Maximum number of fields in any given         */
#define MAX_FLDS 30        /* relation.  If you need more than 30, redefine */
#endif                     /* before #including <mbase.h>                   */

#define OKAY                  0   /* Generic no-problem number.  Thank IBM. */
#define NOT_ENOUGH_ROOM   -1000   /* Too many files are open at once        */
#define CANNOT_OPEN_REL   -1001   /* Can't open FILE.REL                    */
#define RELATION_HUNG     -1002   /* User left during add/del/upd.  See dox */
#define CANNOT_READ_REL   -1003   /* FILE.REL is protected (Need rw access) */
#define RELATION_BUSY     -1004   /* 120 users on one relation=max (Hah!)   */
#define RELATION_LOCKED   -1005   /* Someone has locked the relation        */
#define LOCK_DENIED       -1006   /* Can't lock with other users.  See dox  */
#define ILLEGAL_DUPLICATE -1007   /* Record would violate a nodups index    */
#define CORRUPT_INDEX     -1008   /* Means you're fucked.  Probly not used  */
#define INVALID_FILE_CODE -1009   /* You've passed an unreal relation numb  */
#define NOT_OPEN          -1010   /* You've tried to work with a closed rel */
#define RCD_INVALID       -1011   /* Bad-size or # of flds given to add/upd */
#define INVALID_COMP      -1012   /* SELECT's record for comparison is bad  */
#define UNKNOWN_ACTION    -1013   /* You'll probly never get this one.      */
#define NOT_FOUND         -1014   /* Generic.  Can't find the record U want */
#define NO_CURRENT_RECORD -1015   /* Must select a record before del/upd    */
#define INVALID_INDEX     -1016   /* A bad index # has been sent to mb_sel  */

#define CURR                  1   /* Re-read the current record (4 mb_sel)  */
#define EQUL                  2   /* Get rec that matches exactly (see dox) */
#define FRST                  3   /* Get the first record, sequentially     */
#define GTEQ                  4   /* If not exact, get the one right after  */
#define GTHN                  5   /* Like GTEQ, but won't accept exact one  */
#define LAST                  6   /* Get the last record, sequentially      */
#define LTEQ                  7   /* If not exact, get the one right before */
#define LTHN                  8   /* Like LTEQ, but won't accept exact one  */
#define NEXT                  9   /* Get the next record, sequentially      */
#define PREV                 10   /* Get the previous record, sequentially  */

#define CURRENT            CURR   /* These are included to reduce errors    */
#define EQUAL              EQUL   /* due to stupid humans who insist on     */
#define FIRST              FRST   /* using long words instead of short ones */
#define GTHAN              GTHN   /*                                        */
#define LTHAN              LTHN   /* Gee, I'm considerate.                  */
#define PREVIOUS           PREV   /*                                        */

#define ZEROES "\001\001\001\001\001\001\001\001\001\001\001\001."

/****************************************************************************/
/*                                                                          */
/* A reminder of the single rule that applies to EVERYTHING in this file:   */
/*                                                                          */
/* If you don't understand it, DON'T SCREW WITH IT.                         */
/*                                                                          */
/* I'd like to emphasize that this rule is _most_important_ in viewing the  */
/* follow section of definitions.  If you wanna change the internal         */
/* structure of the relations, and think you can (successfully, that is),   */
/* go right ahead.  And send me a copy of the "better" MetalBase when you   */
/* think you're finished... I'd like to see it.  :-)                        */
/*                                                                          */
/****************************************************************************/

#define _t_top(f,i)    4 +  4*i
#define _idxs(f)           13*(_list[f].num_idx)
#define _num_recs(f)   5 +  4*(_list[f].num_idx)

#define _block(f)      11+(4*_list[f].num_idx)
#define _base(f,r)     _block(f)+_list[f].relbase+(r-1)*((13*_list[f].num_idx)+\
                          2+(_list[f].rec_len))
#define _l_ptr(f,i,r)  _base  (f, r)    + 13*i
#define _r_ptr(f,i,r)  _l_ptr (f, i, r) +  4
#define _b_ptr(f,i,r)  _r_ptr (f, i, r) +  4
#define _rec(f,r)      _base  (f, r)    + (13*_list[f].num_idx) + 1

#define _len(f)        2 + _idxs (f) + _list[f].rec_len

/*                               Whew!                                      */

char   buffer [BUF_LEN];

int  _Started = -1;

#define mb_key(a,b,c) _skey(a,b-1,c)

struct
{  long  int   pos,      relbase;
         int   relcode;
         int   num_idx,  rec_len;

         int   idx_dups  [20];
         int   idx_just  [MAX_FLDS];
         int   idx_num   [20][6];
         int   idx_start [20][6];
         int   idx_stop  [20][5];

         char  filename  [80];     } _list [MAX_REL];

