#include "stdinc.h"
#include "mbase.h"

/* INDICIES:
	1 -- noun
	2 -- question|goodbad
	3 -- question               */

static char *records[] =
 { "1|aReallyGoodKWIn1|r", "2|betterKeyWordin2|r",
   "10|aGoodKWordIn10|r",  "1|aRottenKWordIn1|w",
   "2|nastyKeyWordin2|w",  "10|aRottenKWordIn10|w",
   "2|nastyKeyWordin2|w",  "2|aGoodKeyWordIn2|r",
   "1|aGoodKeyWordIn1|r",  "10|greatOnein10|r",
   "0"
 };

int    f;        /* Int into which to place the file # after mb_inc    */
char   str[80];  /* Generic global char * into which to return records */

static int KEY = 128;  /* Encryption key to use on the file */

main ()
{
   int   i, func;
   char  temp[80], validkey[80];

   if ((f = mb_inc ("sample", KEY)) < 0)
    { printf ("Relation could not be opened.\n");
      exit   (0);
    };
   printf ("Relation has been included -- %d.\n\n", f);

   printf ("Relation has been cleaned  -- %d.\n\n", mb_rst ("sample"));

   printf ("Adding records (If they're not there)\n");
   printf ("   ('!' = already there, '.' = added)\n");

   for (i = 0; records[i][0] != '0'; i++)
      printf ( (mb_add (f, records[i]) == 0) ? "." : "!" );
   printf ("\n");

   printf ("Printing all words in the relation:\n");

   for (func = FIRST; mb_sel (f, 1, str, func, "") == 0; func = NEXT)
      print_record ("<validkey unused>");

   printf ("\nLooking up 'greatOnein10'\n");
   if (mb_sel (f, 1, str, EQUAL, "greatOnein10") == 0)
      print_record ("<validkey unused>");
   else
      printf ("Couldn't find it.\n");

   printf ("\nPrinting all good words in question 1:\n");
   strcpy (temp, "1|r|");
   for (func = EQUAL; ; func = NEXT)
    { if (mb_sel (f, 2, str, func, temp) != 0)  break;
      if (func == EQUAL)  strcpy (validkey, mb_key (f, 2, str));
      else
         if (strcmp (validkey, mb_key (f, 2, str)) != 0)  break;
      print_record (validkey);
    };

   printf ("\nPrinting all bad words in question 2:\n");
   strcpy (temp, "2|w|");
   for (func = EQUAL; ; func = NEXT)
    { if (mb_sel (f, 2, str, func, temp) != 0)  break;
      if (func == EQUAL)  strcpy (validkey, mb_key (f, 2, str));
      else
         if (strcmp (validkey, mb_key (f, 2, str)) != 0)  break;
      print_record (validkey);
    };

   printf ("\nPrinting all words in question 10:\n");
   strcpy (temp, "10|");
   for (func = EQUAL; ; func = NEXT)
    { if (mb_sel (f, 3, str, func, temp) != 0)  break;
      if (func == EQUAL)  strcpy (validkey, mb_key (f, 3, str));
      else
         if (strcmp (validkey, mb_key (f, 3, str)) != 0)  break;
      print_record (validkey);
    };

   printf ("Relation has been closed -- %d\n", mb_rmv (f));
}

print_record (extra)
char         *extra;
{
   printf (" %s [ %s ]\n", str, extra);
}

/*

LOOK UP A SPECIFIC RECORD:
   mb_sel (f, idx, str, EQUAL, "comparison|");

UPDATE CURRENT RECORD:
   sprintf (str, "%s", "<type in your new record value here>");
   mb_upd (f, str);

DELETE CURRENT RECORD:
   mb_del (f, 0);       The 0 is so you can't compile if you've confused
                        mb_del with mb_rmv

RETRIEVE CURRENT RECORD:
   mb_sel (f, idx, str, CURR, "");
   print_record ();

*/

