	// bdrdem1.cpp
	// Demo of the two Binder constructors
	// Link with binder.obj
	
	// Think of a Binder as an elastic array of void
	// pointers.  The array can be accessed 
	// interchangeably as a stack-queue-deque-list.

	#include <string.h>	
	#include <iomanip.h>
	#include "binder.hpp"


	char *V[] = {
		"Now is the time",
		"for all programmers",
		"to stop reinventing",
		"the linked list!",
		0
	};
	
	void display(char *S)
		{ cout << S << endl; }


	main()
	{
		Binder B1;

		for (int i = 0; B1.insQ(V[i]); i++);

		cout << "\n\nQueued vector:\n\n";

		while (B1.next())	// walk the list
			cout << (char *)(voiD) B1 << endl;
		
		cout << "\n\nPress enter to continue ... ";
		cin.get();
		
		
		
		BindeR B2 = new
			Binder(BDR_OK_FREE,3);
		
		for (i = 0; B2->insQ(strdup(V[i])); i++);
		
		cout << "\n\nQueued cloned vector "
			<< "limited to 3 nodes:\n\n";
		
		B2->forEach((BDRforEachBlocK)display);
		
		delete B2;
		


		Binder B3((voiDV)V);

		cout << "\n\nVector exploded into a binder:\n\n";
		
		while (B3++)	// iterate over the list
			cout << (char *) B3.current() << endl;

		cout << "\n\nPress enter to quit ... ";
		cin.get();



		return 0;
	}
