#define MAXINDEX 5

struct	DBfile {
	int		rs;							/* Record size (bytes)				*/
	int		rn;							/* Current record number			*/
	int		mr;							/* Maximum record number			*/
	int		ni;							/* Number of index files open		*/
	int		ci;							/* Current index file				*/
	void	*rec;						/* Pointer to temporary record		*/
	FILE	*fp;						/* Pointer to database file handle	*/
	FILE	*idxfp[MAXINDEX];			/* Index file handle pointer array	*/
	int		(*idxfn[MAXINDEX])();		/* Index function pointer array		*/
	struct	DBfile *last;				/* Pointer to last structure		*/
	struct	DBfile *next;				/* Pointer to next structure		*/
};

typedef struct DBfile DBfile;

struct	DBifile {
	uint16	last;
	uint16	next;
};

typedef struct DBifile DBifile;

DBfile	*DBopen(char *,int);
void	DBend();
int		DBselect(DBfile *);
int		DBindex(char *,int (*)());
int		DBsetindex(int);
DBfile	*DBclose();
int		DBcmp(void *,void *);
int		DBcopy(void *,void *);
int		DBread(void *);
int		DBgo(int);
int		DBadd(void *);
int		DBwrite(void *);
int		DBreadn(int,void *);
int		DBiread(int,int);
int		DBiwrite(int);
int		DBrecno();
int		DBskip(int);
int		DBdelete();
int		DBfindfirst(void *);
int		DBfindnext(void *);
int		DBseekfirst(void *,int (*)());
int		DBseeknext(void *,int (*)());
