# 1994 IOCCC Winners makefile for use with Symantec C 6.1 under MS-DOS.
#
# Copyright (c) 1994, Landon Curt Noll & Larry Bassel.
# Symantec modifications Copyright 1994, Thad Smith & Ray Gardner
#
# All Rights Reserved.  Permission for personal, educational or non-profit
# use is granted provided this this copyright and notice are included in its
# entirety and remains unaltered.  All other uses must receive prior permission
# in writing from both Landon Curt Noll and Larry Bassel.
#
# Thanks go to Landon Curt Noll for permission to make and distribute
# this MS-DOS version makefile.

# Original environment was ANSI C under Unix.
# This makefile compiles the programs under Symantec C for MS-DOS,
# using Symantec's make program.  Use "make -f makefile.sc"
# Following are the differences for MS-DOS make:
#
#  The following don't compile:
#    dodsond2.orig- requires tools normally not present.
#    shapiro2.c   - requires pipe() and fork().  Note that the original
#                   file shapiro.c does compile (to shapiro1.exe) and run.
#    tvr.c        - requires X Windows library (maybe it will work on
#                   YOUR system).
#    tvra.c       - requires X Windows library.
#    weisberg.alt - requires too much memory.
#
#  The following were adjusted in the makefile procedure:
#    dodsond1,2.c - make the following function name substitution via
#                   macros to allow running under ANSI library:
#                        random = rand,  srandom = srand,
#                        getpid = (srand(time(NULL)),rand(),rand)
#                   Function getpid is not equivalent to the replacement,
#                   but, in context, the replacement provides for
#                   random number initialization, which was the intent
#                   of the original code.
#    gtface.c     - create a dummy curses.h, which isn't needed, but
#                   the source includes it.
#    imc.c        - getpid is redefined by a commandline macro to
#                   provide for random number initialization.
#
#  The following needs manual adjustment:
#    shapiroa.c   - change the definitions of macros SAVE and RESTORE to
#                        #define SAVE     "\033[s"
#                        #define RESTORE  "\033[u"
#                   in order to be compatible with ANSI.SYS.
#                   Delete the line with strlen and change %s to %.24s
#                   to work around a bug in the Symantec library.
#                   Exit with ^Break.
#
# Notes:
#    All sources files are exactly as released from IOCCC.

# flags for ANSI compiles
#
# NOTE: Some ANSI compilers make use of -Xa to turn on ANSI mode,
#       others such as gcc may want -ansi, others may want nothing
#       at all.  Adjust the CFLAGS line as needed.
#
# NOTE: Some compilers cannot optimize, or optimize some entries
#       entries incorrectly.  You might want need to turn on -O 
#       to see if your compiler can handle them.
#
#  Symantec 6.1: -A = strict ANSI,  -p = turn off autoprototyping,
#             -w = no warnings
#       You might want to increase the warning level to see warnings.
CFLAGS= -A -p -w

# ANSI compiler
#
# Set CC to the name of your ANSI compiler.
CC=sc

# winners that compile under ANSI C
WINNERS1= dodsond1.exe dodsond2.exe horton.exe imc.exe ldb.exe
WINNERS2= schnitzi.exe shapiro.exe smr.exe weisberg.exe westley.exe
WINNERS=$(WINNERS1) $(WINNERS2)
ALT_NAMES=shapiroa.exe hortona.exe gtface.exe

all: $(WINNERS) $(ALT_NAMES)

westley.exe: westley.c
        $(CC) $(CFLAGS) -DO westley.c

# Symantec kluge: Symantec make seems to offer no built-in facility 
#    for creating a text file from lines embedded in the makefile. 
#    The usual method of using the DOS echo command with > and >>
#    redirection won't work here because of the C operators >, <, and
#    << in the command-line macro definitions.  So we use echo
#    commands to create a script file for the DOS debug command and
#    then use debug to create the actual command line "response file"
#    containing the macro definitions.  We also had to replace the
#    embedded blank in the printf() format string with a \40;
#    Symantec C didn't accept the embedded blank.
#
#    Original definitions from the Unix makefile:
#       -Dc='n*n>x?p:((m=*(b+1)),N))'                   \
#       -De='(2<<6*sizeof(int))'                        \
#       -Do='(8<<5*sizeof(int))'                        \
#       -DN='((b=t+1),x+=2,x>e?exit():o'                \
#       -Dp='(a-t<o?*(a++)=x:47),printf("%d ",x),N)'    \


weisberg.exe: weisberg.c
        del debug.scr
        del sc.rsp
        @echo e 100 '-Dc=n*n' 3E 'x?p:((m=*(b+1)),N)) ' 0D 0A>debug.scr
        @echo e 11E '-De=(2' 3C 3C '6*sizeof(int)) ' 0D 0A>>debug.scr
        @echo e 137 '-Do=(8' 3C 3C '5*sizeof(int)) ' 0D 0A>>debug.scr
        @echo e 150 '-DN=((b=t+1),x+=2,x' 3E 'e?exit():o ' 0D 0A>>debug.scr
        @echo e 171 '-Dp=(a-t' 3C 'o?*(a++)=x:47),printf("' 25 'd\40",x),N) '\
0D 0A>>debug.scr
        @echo rcx>>debug.scr
        @echo A0>>debug.scr
        @echo n sc.rsp>>debug.scr
        @echo w>>debug.scr
        @echo q>>debug.scr
        +debug < debug.scr
        $(CC) $(CFLAGS) @sc.rsp weisberg.c

#tvr.exe: tvr.c
#        @echo tvr cannot be made under DOS

# The following is an alternate version of tvr.  Modes 0-3 have been
# renumbered 1-4.  Mode 0 is Mandelbrot / julian calculated correctly.
#
#tvra.exe: tvra.c
#        @echo tvra.exe cannot be made under DOS

smr.exe: smr.c
        xcopy smr.c *.exe

shapiro.exe: shapiro2.c
        @echo shapiro.exe cannot be made under DOS

shapiro2.c: shapiro1.exe
        del shapiro2.c
        +shapiro1 > shapiro2.c

shapiro1.exe: shapiro.c
        $(CC) $(CFLAGS) -oshapiro1 shapiro.c

shapiroa.exe: shapiroa.c
        $(CC) $(CFLAGS) -Dsleep=while(i==time(NULL)) shapiroa.c

schnitzi.exe: schnitzi.c
        $(CC) $(CFLAGS) schnitzi.c

horton.exe: horton.c
        $(CC) $(CFLAGS) horton.c

# Here are some programs related to the horton entry.  See horton.hint
# for details.
#
hortona.exe: hortona.c
        $(CC) $(CFLAGS) hortona.c

gtface.exe: gtface.c curses.h
        $(CC) $(CFLAGS) -I.\ gtface.c

#  Create a dummy curses.h in current directory.
curses.h: gtface.c
        echo /* dummy curses.h */>curses.h

ldb.exe: ldb.c
        $(CC) $(CFLAGS) ldb.c

imc.exe: imc.c
        $(CC) $(CFLAGS) -Dgetpid=(srand(time(NULL)),rand(),rand) imc.c

dodsond2.exe: dodsond2.c
        $(CC) $(CFLAGS) -Drandom=rand -Dsrandom=srand \
-Dgetpid=(srand(time(NULL)),rand(),rand) dodsond2.c

# NOTE: this is the original (gziped) file that won
#
#dodsond2.orig: dodsond2.gz
#        @${RM} -f dodsond2.orig.c
#        -${GUNZIP} < dodsond2.gz > dodsond2.orig.c
#        -@if [ -s dodsond2.orig.c ]; then \
#            ${ECHO} "$(CC) $(CFLAGS) dodsond2.orig.c -o dodsond2.orig"; \
#            $(CC) $(CFLAGS) dodsond2.orig.c -o dodsond2.orig; \
#        else \
#            ${RM} -f dodsond2.orig.c; \
#            ${ECHO} "sorry, we could not gunzip dodsond2.gz"; \
#        fi
#
#dodsond2.gz: dodsond2.uue
#        del dodsond2.gz
#        ${UUDECODE} dodsond2.uue

dodsond1.exe: dodsond1.c
        $(CC) $(CFLAGS) -Drandom=rand dodsond1.c

clean:
        del *.obj
        del *.tmp
        del *.bak
        del defs.cfg
        del curses.h
        del sc.rsp
        del debug.scr
        touch clean

clobber: clean
        for %s in ($(WINNERS1)) do del %s
        for %s in ($(WINNERS2)) do del %s
        for %s in ($(ALT_NAMES)) do del %s
        del shapiro1.*
        del shapiro2.*
        del clean

nuke: clobber

