#include "insert.h"

/*#define REGISTERED*/

TABLEHANDLE TH=NULL;
FILE *FP;
char SEP='|';
unsigned CAR=0;	/* current ascii file record */


void main(int argc,char *argv[])
{
FILE *fpe;
fpos_t fpi;
char *asciirec;
unsigned loaded=0;
int exitcode=0;
long size;

size=(unsigned)coreleft()/2;
if(size>65520L) size=65520L;
asciirec=memreq((unsigned)size);

cprintf("\n\rINSERT data loader version 1.10    12/22/93\n\r(C) John Hutchey 1993   All Rights Reserved\n\r\n\r");

if(argc==4){
	if(strlen(argv[3])==1) SEP=argv[3][0];
	else SEP=NULL;}

if((argc!=3 && argc!=4) || SEP==NULL){
	printf("Usage:  INSERT <source> <dest> <seperator>\n\n\r<Source> is an ASCII text file with fields delineated by |'s.\n\r");
	printf("<Dest> is a Paradox 4.0 table.\n\n\r");
	printf("The order of the fields in the <source> file must\n\rmatch the order of the fields in the <dest> table.\n\r");
	printf("\n\r<Seperator> is an optional parameter which specifies\n\rwhat character the ASCII fields are seperated by\n\r");
	printf("The default seperator (if none is specified) is | .\n\r");
	exit(1);}

OpenFiles(argv[1],argv[2]);

while(!feof(FP) && !ferror(FP)){
	fgetpos(FP,&fpi);
	if(!fgets(asciirec,(unsigned)size,FP)) continue;
	CAR++;
	if(strlen(asciirec)<2) continue;
	if(!(Insert(asciirec,(unsigned)size))){
		fpe=fopen(ERRORFILE,"a");
		if(fpe){
			fsetpos(FP,&fpi);	/* get a new copy of the record because insert() altered it */
			if(fgets(asciirec,(unsigned)size,FP)) fputs(asciirec,fpe);
			fclose(fpe);}
		exitcode=1;
		continue;}
	loaded++;}

printf("\n\r%u of %u records inserted.\n\r",loaded,CAR);
CloseFiles();
#ifndef REGISTERED
if(CAR){
	cprintf("\n\rUnregistered evaluation copy - Please register today.\n\r\n\rPress any key...");
	getch();
	cprintf("\n\n\r");}
#endif
exit(exitcode);
}


int Insert(input,arsize)
char *input;
unsigned arsize;
{
RECORDHANDLE pxrec;
FIELDHANDLE pxf;
TDATE pxdate;
BLOBHANDLE pxbh;
char *af,*taf,*tar,ftype[6];
int ok,mo,da,yr;
long n;
unsigned bloblen;

errchk(FATAL,PXRecBufOpen(TH,&pxrec));					/* set up */

ok=OK;
for(pxf=0,tar=input,af=tar;*tar!=NULL && ok;tar++){					/* find the ascii field */
	if(*tar==SEP){
		pxf++;							/* current ascii field number	*/
		*tar=NULL;						/* *tar now holds the current ascii field */
		ok=errchk(WARN,PXFldType(TH,pxf,6,ftype));
		switch(*ftype){

			case 'D':       mo=0; da=0; yr=0;
					for(taf=af;*taf!=NULL;taf++) if(!isdigit(*taf)) *taf='/';
					sscanf(af,"%d/%d/%d",&mo,&da,&yr);
					ok=errchk(WARN,PXDateEncode(mo,da,yr,&pxdate));
					if(ok) ok=errchk(WARN,PXPutDate(pxrec,pxf,pxdate));
					break;

			case 'S':	n=(atol(af));
					if(n>32768L || n<-32767){
						ok=NOT_OK;
						printf("Warning- Unable to convert numeric field to short number format.\n\r");}
					else ok=errchk(WARN,PXPutShort(pxrec,pxf,atoi(af)));
					break;

			case 'N':
			case '$':	ok=errchk(WARN,PXPutDoub(pxrec,pxf,atof(af)));
					break;

			case 'A':       ok=errchk(WARN,PXPutAlpha(pxrec,pxf,af));
					break;

			default:        bloblen=strlen(af);
					ok=errchk(WARN,PXBlobOpenWrite(pxrec,pxf,&pxbh,bloblen,PXBLOBNEW));
					if(ok) ok=errchk(WARN,PXBlobPut(pxbh,bloblen,0,af));
					if(ok) ok=errchk(WARN,PXBlobClose(pxbh,PXBLOBACCEPT));}

		af=tar+1;}
	}/* end of ASCII record */                                      /* set af to next field */

if(ok) ok=errchk(WARN,PXRecAppend(TH,pxrec));

/* clean-up */
errchk(FATAL,PXRecBufClose(pxrec));
return ok;
}


void OpenFiles(source,dest)
char *source,*dest;
{
char *path,*env;

if(!(FP=fopen(source,"r"))){
	printf("Error- Unable to open source file %s.",source);
	exit(255);}

if(getenv(NETPATH)) env=getenv(NETPATH);
else env="";

path=memreq(strlen(env)+4);
strcpy(path,env);
if(strlen(env)) if(env[strlen(env)-1]!='\\') strcat(path,"\\");
strcat(path,".\\");

errchk(FATAL,PXNetInit(path,LOCALSHARE|PX40LOCKING,"Insert"));

free(path);
errchk(FATAL,PXTblOpen(dest,&TH,0,1));
errchk(FATAL,PXNetTblLock(TH,PWL));
}


void CloseFiles(void)
{
fclose(FP);
PXNetTblUnlock(TH,PWL);
PXTblClose(TH);
PXExit();
}


int errchk(errtype,errno)
int errtype,errno;
{
if(errno==PXSUCCESS) return OK;
if(errtype==FATAL) printf("Error");
else printf("Warning");
if(errno==PXERR_KEYVIOL && CAR) printf("- %s on record %u.\n\r",PXErrMsg(errno),CAR);
else printf("- %s\n\r",PXErrMsg(errno));
if(errtype==FATAL){
	if(TH) CloseFiles();
	exit(255);}
return NOT_OK;
}


void *memreq(n)
unsigned int n;
{
void *buf;

buf=malloc(n);
if(!n){
	printf("Fatal error- Out of memory.\n\r");
	exit(255);}

return buf;
}
