// ObjectWindows - (C) Copyright 1992 by Borland International
//    Dialog created by indirect call using memory template

#ifndef __IND_DIAL_H
#define __IND_DIAL_H

#ifndef __DIALOG_H
#include <dialog.h>
#endif


#pragma option -Vo-
#if     defined(__BCOPT__) && !defined(_ALLOW_po)
#pragma option -po-
#endif


// These are the General Structure definitions for the Dialog Memory Template
// Note that the char fields are variable length strings, so memory must be
// allocated after calculating the length of any of these fields that are
// used, and the data must be accessed via a memory offset.  I have found
// the best success by setting the three fields in DTHeader to NULL and not
// using the DTDetail structure at all.  Children are more easily added to
// the Dialog box using other means.

typedef struct DTHEADER
{
   DWORD lStyle;          // Dialog Box Style
   BYTE  bItemCount;      // Number of Detail Items in Dialog
   WORD  X;               // X pos of Dialog box in Dialog Base Units
   WORD  Y;               // Y pos of Dialog Box in Dialog Base Units
   WORD  CX;              // Width of Dialog Box in Dialog Base Units
   WORD  CY;              // Height of Dialog Box in Dialog Base Units
   char  lpszMenuName;    // These three Chars are actually Character strings
   char  lpszClassName;   // containing variable length data.  I assume a
   char  lpszCaptionText; // default of NULL for each
} DTHeader;

typedef struct DTDETAIL
{
   WORD  X;               // X pos of Child in Dialog Base Units
   WORD  Y;               // Y pos of Child Box in Dialog Base Units
   WORD  CX;              // Width of Child Box in Dialog Base Units
   WORD  CY;              // Height of Child Box in Dialog Base Units
   WORD  wID;             // Child ID
   DWORD lStyle;          // Style code for Child
   char  lpszClassName;   // Child Class Name or Class Code Byte
   char  lpszText;        // Text String for Child
   BYTE  bInfoSize;       // Additional Info bytes
   char  lpszInfoText;    // Additional Info Text   
} DTDetail;

_CLASSDEF(TIndDialog)

  /* TIndDialog */
class _EXPORT TIndDialog : public TDialog
{
protected:
    HANDLE hDialogTemplate;     // Contains Global Handle to local copy
                                // of the Dialog Template 

public:
    // Constructor using Global Handle to Dialog Memory Template
    TIndDialog( PTWindowsObject AParent, HANDLE hDTemplate, WORD iSize,
		PTModule AModule = NULL);
    // We must free any allocated memory in the Destructor
    ~TIndDialog();
    // The Execute is where the Indirect Call is made to create the Dialog
    virtual int Execute();

    static PTStreamable build();

protected:
    TIndDialog(StreamableInit) : TDialog(streamableInit) {};

private:
    virtual const Pchar streamableName() const
        { return "TIndDialog"; }
};

inline Ripstream operator >> ( Ripstream is, RTIndDialog cl )
    { return is >> (RTStreamable )cl; }
inline Ripstream operator >> ( Ripstream is, RPTIndDialog cl )
    { return is >> (RPvoid)cl; }

inline Ropstream operator << ( Ropstream os, RTIndDialog cl )
    { return os << (RTStreamable )cl; }
inline Ropstream operator << ( Ropstream os, PTIndDialog cl )
    { return os << (PTStreamable )cl; }

#pragma option -Vo.
#if     defined(__BCOPT__) && !defined(_ALLOW_po)
#pragma option -po.
#endif

#endif
