#ifndef IMAGELIB_H
#define IMAGELIB_H

#if defined (JPG_DLL)
#  define _JPGCLASS _export
#elif defined (JPG_APP)
#  define _JPGCLASS _import
#else
#  define _JPGCLASS
#endif

#include <windows.h>
#include <windowsx.h>

extern unsigned int  _JPGCLASS _pascal retjpgfile(const char *filename, int resolution,
					int scale, int option, int password);


extern void _JPGCLASS _pascal readjpgfile(const char *filename, int resolution,
					int scale, int option, int password,
					unsigned int * hddb, unsigned int * hpal);

extern void _JPGCLASS _pascal writejpegfile(const char *filename, int quality,
												 int smooth, int password,
												 unsigned int hddb, unsigned int hpal);

extern void _JPGCLASS _pascal readgiffile(const char *filename,
										  int password, unsigned int * hddb,
										  unsigned int * hpal);

extern void _JPGCLASS _pascal readpcxfile(const char *filename,
										  int password, unsigned int * hddb,
										  unsigned int * hpal);


void ShowMessage();
#endif