//                                               //
// Copyright <c> Borland International, 1993-4   //
//                                               //

//                                                                   //
//  EdHook - Example of IdeHook usage.                               //
//                                                                   //
//      This examples demonstrates hooking the editor's F11 key and  //
//      stuffing a 'stock' class description comment block into      //
//      the current place in the editor buffer                       //
//                                                                   //
                                                                     
#pragma hdrstop

#include "idehook.h"
#include <windows.h>


//  Editor addon

static char szClassHeader[] =
{
    "//\n"
    "//   Class:\n"
    "//\n"
    "//   Description:\n"
    "//\n"
    "//   Last modified date:\n"
    "//   Last modified by:  \n"
    "//\n"
};


int KeyStrokeTest( KeyStroke * )
{
    EditorReq   editor;

    long    line;
    long    col;

    // Move all the way to the left and onto the next line...
    
    editor->inq_position( &line, &col );
    while( col-- )
        editor->left();
    editor->down();

    // Insert the text ...
    
    editor->insert( szClassHeader );

    return(1);
}


//  We need to create an array of KeyStroke structures for   //
//  registering our callbacks                                //

#define NUM_KEYSTROKES  (sizeof(keyStrokes)/sizeof(keyStrokes[0]))

static KeyStroke    keyStrokes[] =
{
    { WM_KEYDOWN, VK_F11, NoModifier,  KeyStrokeTest },
};


//                                                                   //
//  Project stuff                                                    //
//                                                                   //
//      We need to do a one time (for every instance of BCW)         //
//      registration of the keyboard hook. This is done by           //
//      watching Project|Open's and checking our own '_registered'   //
//      flag, if '0', we register and set it to '1'                  //
//                                                                   //
//                                                                   //

class _HOOKCLASS LocalProjClient : public ProjectClient
{
public:
    LocalProjClient();
   
    virtual void _HOOKEP OpenNotify( const char * name );
    virtual void _HOOKEP CloseNotify()  {}
    virtual void _HOOKEP NodeDeleteNotify(ProjectNode) {}
    virtual void _HOOKEP DependencyQueryResponder(ProjectNode,const char*) {}

    int _registered;

};

LocalProjClient::LocalProjClient()
{
   //   Register ourselves as a project client so we'll get notified  //
   //   on project open's                                             //
   
   ProjectReq ps;

   ps->RegisterProjectClient(this);
}


void _HOOKEP    
LocalProjClient::OpenNotify
(
   const char * // name 
)
{
    if( !_registered )
    {
        //  If this is the first time through, then register our  //
        //  keyhit handlers                                       //
        
        EditorReq   editor;

        editor->register_keyhit_handlers( keyStrokes, NUM_KEYSTROKES );

        _registered = 1;
    }
}

static LocalProjClient LocalProjClient;
    
// End of file
