//-------+---------+---------+---------+---------+---------+---------+---------+
// 1991-1992 Betz Associates. Released to the Public Domain. This source code
// is offered without warranty or guarantee of any kind, and the author(s)
// expressly disclaim any responsibility for consequences of it's use in
// products for commercial, shareware, or public domain release of any kind.
//
// File Name: TMREXAM.CPP
// Creation:  August 2, 1992
// Author:    Mark Betz (MB)
//
// Machine:   IBM PC and Compatibles
//
// Includes:  nothing
//
//-------+---------+---------+---------+---------+---------+---------+---------+
// Change History
// ------ -------
//
//      Date            Rev.	Author		Purpose
//      ----            ----    ------      -------
//      9-20-1992       1.0     MB          Update release v 1.1
//
// Description
// -----------
//      Example program showing how to use the HTimer class
//
//-------+---------+---------+---------+---------+---------+---------+---------+

#include <conio.h>
#include <stdlib.h>
#include <dos.h>

#ifndef __TYPES__
   #include "types.h"
#endif
#ifndef __HTIMER__
   #include "htimer.h"
#endif

HTimer timer1;                 // instance of HTimer object
HTimer* timer2;                // pointer to HTimer object

int main()
   {
   HTimer timer3;              // function-scope instance of HTimer object
   char input;                 // for user input
   dword etime;                // used to hold elapsed times

   clrscr();
   cprintf("**************************************************************\r\n");
   cprintf("***                 HTimer Example Program                 ***\r\n");
   cprintf("**************************************************************\r\n\r\n");
   cprintf("creating timer2 on the heap... ");
   if ((timer2 = new HTimer()) != NULL)
      {
      cprintf("done\r\n\r\n");
      cprintf("starting timer 1... ");
      timer1.timerOn();
      cprintf("done\r\n\r\n");
      cprintf("timing your keypress with timer2:\r\n");
      cprintf("   press any key... ");
      timer2->timerOn();
      while(kbhit()) getch();
      input = getch();
      etime = timer2->timerOff();
      cprintf("done\r\n");
      cprintf("timer 2 says you took %li microseconds to press the key\r\n\r\n",
              etime);
      etime = timer1.getElapsed();
      cprintf("timer 1 has been running for %li microseconds\r\n\r\n", etime);
      cprintf("timing your keyboard knowlege with timer 3:\r\n");
      cprintf("   press the 'H' key... ");
      input = 0;
      timer3.timerOn();
      while(kbhit()) getch();
      while(( input != 'h' ) && ( input != 'H' ))
         input = getch();
      etime = timer3.timerOff();
      cprintf("done\r\n");
      cprintf("timer 3 says you took %li microseconds to find the key\r\n\r\n",
              etime);
      cprintf("stopping timer 1... ");
      etime = timer1.timerOff();
      cprintf("done\r\n");
      cprintf("timer 1 ran for a total of %li microseconds\r\n\r\n", etime);
      cprintf("deleting timer 2... ");
      delete(timer2);
      cprintf("done\r\n");
      } else cprintf("\r\nallocation of timer2 failed\r\n");
   return(0);
   }





