/**************************************************************************
These C++ classes are copyright 1989, 1990, 1991 by William Herrera.
I hereby release this source code for free distrubution and use.
If you modify it and distribute it, please indicate any changes you
make as your own and the code as copyrighted above.
**************************************************************************/
// file pointerh.cpp class definitions for PointerHeap class.

#include <iostream.h>
#include <stdlib.h>

#include "error.hpp"

#include "pointerh.hpp"

PointerHeap::PointerHeap(int siz) : size(siz) 
{
	heap = new void *[size];
	if(heap == NULL)
		Error("\nCannot allocate memory\n");
	else
	{

		last = &heap[size - 1];
		for(void **p = heap; p < last; )
		{
			void ** q = p + 1;
			*p = (void *)q;
			p = q;
		}
		*last = NULL;
		nextAvailable = heap;
	}
}

PointerHeap::~PointerHeap()
{
	if(heap != NULL)
		delete heap;
}

void ** PointerHeap::Allocate()
{
	void ** retval = NULL;
	if(nextAvailable != NULL)
	{
		retval = nextAvailable;
		nextAvailable = (void **)(*nextAvailable);
	}
	return retval;
}

void PointerHeap::Deallocate(void ** p)
{
	if(p >= heap && p <= last)
	{
		void ** temp = nextAvailable;
		nextAvailable = p;
		*p = (void *)temp;
	}
}


// end of file pointerh.cpp
